/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.xml;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.util.XmlEventUtil;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.io.xml.DefaultXmlProblemHandler;
import gov.nist.secauto.metaschema.databind.io.xml.IXmlParsingContext;
import gov.nist.secauto.metaschema.databind.io.xml.IXmlProblemHandler;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.IBoundInstance;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldScalar;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedNamed;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IFeatureScalarItemValueHandler;
import gov.nist.secauto.metaschema.databind.model.info.IItemReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.stax2.XMLEventReader2;

public class MetaschemaXmlReader
implements IXmlParsingContext {
    private static final Logger LOGGER = LogManager.getLogger(MetaschemaXmlReader.class);
    @NonNull
    private final XMLEventReader2 reader;
    @NonNull
    private final IXmlProblemHandler problemHandler;

    public MetaschemaXmlReader(@NonNull XMLEventReader2 reader) {
        this(reader, new DefaultXmlProblemHandler());
    }

    public <ITEM> ITEM readItem(@NonNull IBoundObject item, @NonNull IBoundInstance<ITEM> instance, @NonNull StartElement start) throws IOException {
        return (ITEM)instance.readItem(item, new ItemReadHandler(start));
    }

    public MetaschemaXmlReader(@NonNull XMLEventReader2 reader, @NonNull IXmlProblemHandler problemHandler) {
        this.reader = reader;
        this.problemHandler = problemHandler;
    }

    @Override
    public XMLEventReader2 getReader() {
        return this.reader;
    }

    @Override
    public IXmlProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    @Override
    @NonNull
    public <CLASS> CLASS read(@NonNull IBoundDefinitionModelComplex definition) throws IOException {
        try {
            if (this.reader.peek().isStartDocument()) {
                XmlEventUtil.consumeAndAssert((XMLEventReader2)this.reader, (int)7);
            }
            XmlEventUtil.skipEvents((XMLEventReader2)this.reader, (int[])new int[]{4, 3, 11});
            XMLEvent event = (XMLEvent)ObjectUtils.requireNonNull((Object)this.reader.peek());
            if (!event.isStartElement()) {
                throw new IOException(String.format("The token '%s' is not an XML element%s.", XmlEventUtil.toEventName((XMLEvent)event), XmlEventUtil.generateLocationMessage((XMLEvent)event)));
            }
            ItemReadHandler handler = new ItemReadHandler((StartElement)ObjectUtils.notNull((Object)event.asStartElement()));
            Object value = definition.readItem(null, handler);
            if (value == null) {
                event = this.reader.peek();
                throw new IOException(String.format("Unable to read data.%s", event == null ? "" : XmlEventUtil.generateLocationMessage((XMLEvent)event)));
            }
            return (CLASS)ObjectUtils.asType(value);
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    protected void readFlagInstances(@NonNull IBoundDefinitionModelComplex targetDefinition, @NonNull IBoundObject targetObject, @NonNull StartElement start) throws IOException, XMLStreamException {
        Map flagInstanceMap = targetDefinition.getFlagInstances().stream().collect(Collectors.toMap(IFlagInstance::getXmlQName, Function.identity()));
        for (Attribute attribute : CollectionUtil.toIterable((Iterator)((Iterator)ObjectUtils.notNull(start.getAttributes())))) {
            QName qname = attribute.getName();
            IBoundInstanceFlag instance = (IBoundInstanceFlag)flagInstanceMap.get(qname);
            if (instance == null) {
                if (this.getProblemHandler().handleUnknownAttribute(targetDefinition, targetObject, attribute, this)) continue;
                throw new IOException(String.format("Unrecognized attribute '%s'%s.", qname, XmlEventUtil.generateLocationMessage((XMLEvent)attribute)));
            }
            try {
                Object value = instance.getDefinition().getJavaTypeAdapter().parse((String)ObjectUtils.notNull((Object)attribute.getValue()));
                instance.setValue(targetObject, value);
                flagInstanceMap.remove(qname);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException(String.format("Malformed data '%s'%s. %s", attribute.getValue(), XmlEventUtil.generateLocationMessage((XMLEvent)start), ex.getLocalizedMessage()), ex);
            }
        }
        if (!flagInstanceMap.isEmpty()) {
            this.getProblemHandler().handleMissingFlagInstances(targetDefinition, targetObject, (Collection)ObjectUtils.notNull(flagInstanceMap.values()));
        }
    }

    protected void readModelInstances(@NonNull IBoundDefinitionModelAssembly targetDefinition, @NonNull IBoundObject targetObject) throws IOException {
        Collection instances = targetDefinition.getModelInstances();
        HashSet<IBoundInstanceModel> unhandledProperties = new HashSet<IBoundInstanceModel>();
        for (IBoundInstanceModel modelInstance : instances) {
            assert (modelInstance != null);
            if (this.readItems(modelInstance, targetObject, true)) continue;
            unhandledProperties.add(modelInstance);
        }
        this.getProblemHandler().handleMissingModelInstances(targetDefinition, targetObject, unhandledProperties);
        try {
            if (!this.getReader().peek().isEndElement()) {
                XmlEventUtil.skipWhitespace((XMLEventReader2)this.getReader());
                XmlEventUtil.skipElement((XMLEventReader2)this.getReader());
                XmlEventUtil.skipWhitespace((XMLEventReader2)this.getReader());
            }
            XmlEventUtil.assertNext((XMLEventReader2)this.getReader(), (int)2);
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    protected boolean isNextInstance(@NonNull IBoundInstanceModel<?> targetInstance) throws XMLStreamException {
        XmlEventUtil.skipWhitespace((XMLEventReader2)this.reader);
        XMLEvent nextEvent = this.reader.peek();
        boolean retval = nextEvent.isStartElement();
        if (retval) {
            QName qname = (QName)ObjectUtils.notNull((Object)nextEvent.asStartElement().getName());
            retval = qname.equals(targetInstance.getEffectiveXmlGroupAsQName()) || targetInstance.canHandleXmlQName(qname);
        }
        return retval;
    }

    @Override
    public <T> boolean readItems(@NonNull IBoundInstanceModel<T> instance, @NonNull IBoundObject parentObject, boolean parseGrouping) throws IOException {
        try {
            boolean handled = this.isNextInstance(instance);
            if (handled) {
                ModelInstanceReadHandler<T> handler;
                IModelInstanceCollectionInfo<T> collectionInfo;
                Object value;
                QName groupQName;
                QName qName = groupQName = parseGrouping ? instance.getEffectiveXmlGroupAsQName() : null;
                if (groupQName != null) {
                    XmlEventUtil.requireStartElement((XMLEventReader2)this.reader, (QName)groupQName);
                }
                if ((value = (collectionInfo = instance.getCollectionInfo()).readItems(handler = new ModelInstanceReadHandler<T>(instance, parentObject))) != null) {
                    instance.setValue(parentObject, value);
                }
                XmlEventUtil.skipWhitespace((XMLEventReader2)this.reader);
                if (groupQName != null) {
                    XmlEventUtil.requireEndElement((XMLEventReader2)this.reader, (QName)groupQName);
                }
            }
            return handled;
        }
        catch (XMLStreamException ex) {
            throw new IOException(ex);
        }
    }

    private final class ItemReadHandler
    implements IItemReadHandler {
        @NonNull
        private final StartElement startElement;

        private ItemReadHandler(StartElement startElement) {
            this.startElement = startElement;
        }

        @NonNull
        private StartElement getStartElement() {
            return this.startElement;
        }

        @NonNull
        private <DEF extends IBoundDefinitionModelComplex> IBoundObject readDefinitionElement(@NonNull DEF definition, @NonNull StartElement start, @NonNull QName expectedQName, @Nullable IBoundObject parent, @NonNull DefinitionBodyHandler<DEF, IBoundObject> bodyHandler) throws IOException {
            try {
                XmlEventUtil.requireStartElement((XMLEventReader2)MetaschemaXmlReader.this.reader, (QName)expectedQName);
                Location location = start.getLocation();
                IBoundObject item = definition.newInstance(location == null ? null : () -> new MetaschemaData(location));
                definition.callBeforeDeserialize(item, parent);
                MetaschemaXmlReader.this.readFlagInstances(definition, item, start);
                bodyHandler.accept(definition, item);
                XmlEventUtil.skipWhitespace((XMLEventReader2)MetaschemaXmlReader.this.reader);
                definition.callAfterDeserialize(item, parent);
                XmlEventUtil.requireEndElement((XMLEventReader2)MetaschemaXmlReader.this.reader, (QName)expectedQName);
                return (IBoundObject)ObjectUtils.asType((Object)item);
            }
            catch (BindingException | XMLStreamException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public Object readItemFlag(IBoundObject parent, IBoundInstanceFlag flag) throws IOException {
            throw new UnsupportedOperationException("handled by readFlagInstances()");
        }

        private void handleFieldDefinitionBody(@NonNull IBoundDefinitionModelFieldComplex definition, @NonNull IBoundObject item) throws IOException {
            IBoundFieldValue fieldValue = definition.getFieldValue();
            Object value = fieldValue.readItem(item, this);
            if (value != null) {
                fieldValue.setValue((Object)item, value);
            }
        }

        @Override
        public Object readItemField(IBoundObject parent, IBoundInstanceModelFieldScalar instance) throws IOException {
            try {
                QName wrapper = null;
                if (instance.isEffectiveValueWrappedInXml()) {
                    wrapper = instance.getXmlQName();
                    XmlEventUtil.skipWhitespace((XMLEventReader2)MetaschemaXmlReader.this.getReader());
                    XmlEventUtil.requireStartElement((XMLEventReader2)MetaschemaXmlReader.this.getReader(), (QName)wrapper);
                }
                Object retval = this.readScalarItem(instance);
                if (wrapper != null) {
                    XmlEventUtil.skipWhitespace((XMLEventReader2)MetaschemaXmlReader.this.getReader());
                    XmlEventUtil.requireEndElement((XMLEventReader2)MetaschemaXmlReader.this.getReader(), (QName)wrapper);
                }
                return retval;
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public IBoundObject readItemField(IBoundObject parent, IBoundInstanceModelFieldComplex instance) throws IOException {
            return this.readDefinitionElement(instance.getDefinition(), this.getStartElement(), instance.getXmlQName(), parent, this::handleFieldDefinitionBody);
        }

        @Override
        public IBoundObject readItemField(IBoundObject parent, IBoundInstanceModelGroupedField instance) throws IOException {
            return this.readDefinitionElement(instance.getDefinition(), this.getStartElement(), instance.getXmlQName(), parent, this::handleFieldDefinitionBody);
        }

        @Override
        public IBoundObject readItemField(IBoundObject parent, IBoundDefinitionModelFieldComplex definition) throws IOException {
            return this.readDefinitionElement(definition, this.getStartElement(), definition.getXmlQName(), parent, this::handleFieldDefinitionBody);
        }

        @Override
        public Object readItemFieldValue(IBoundObject parent, IBoundFieldValue fieldValue) throws IOException {
            return this.checkMissingFieldValue(this.readScalarItem(fieldValue));
        }

        @Nullable
        private Object checkMissingFieldValue(Object value) throws IOException {
            if (value == null && LOGGER.isWarnEnabled()) {
                StartElement start = this.getStartElement();
                LOGGER.atWarn().log("Missing property value{}", (Object)XmlEventUtil.generateLocationMessage((XMLEvent)start));
            }
            return value;
        }

        private void handleAssemblyDefinitionBody(@NonNull IBoundDefinitionModelAssembly definition, @NonNull IBoundObject item) throws IOException {
            MetaschemaXmlReader.this.readModelInstances(definition, item);
        }

        @Override
        public IBoundObject readItemAssembly(IBoundObject parent, IBoundInstanceModelAssembly instance) throws IOException {
            return this.readDefinitionElement(instance.getDefinition(), this.getStartElement(), instance.getXmlQName(), parent, this::handleAssemblyDefinitionBody);
        }

        @Override
        public IBoundObject readItemAssembly(IBoundObject parent, IBoundInstanceModelGroupedAssembly instance) throws IOException {
            return this.readDefinitionElement(instance.getDefinition(), this.getStartElement(), instance.getXmlQName(), parent, this::handleAssemblyDefinitionBody);
        }

        @Override
        public IBoundObject readItemAssembly(IBoundObject parent, IBoundDefinitionModelAssembly definition) throws IOException {
            return this.readDefinitionElement(definition, this.getStartElement(), (QName)ObjectUtils.requireNonNull((Object)definition.getRootXmlQName()), parent, this::handleAssemblyDefinitionBody);
        }

        @Nullable
        private Object readScalarItem(@NonNull IFeatureScalarItemValueHandler handler) throws IOException {
            return handler.getJavaTypeAdapter().parse(MetaschemaXmlReader.this.getReader());
        }

        @Override
        public IBoundObject readChoiceGroupItem(IBoundObject parent, IBoundInstanceModelChoiceGroup instance) throws IOException {
            try {
                XMLEventReader2 eventReader = MetaschemaXmlReader.this.getReader();
                XmlEventUtil.skipWhitespace((XMLEventReader2)eventReader);
                XMLEvent event = eventReader.peek();
                QName nextQName = (QName)ObjectUtils.notNull((Object)event.asStartElement().getName());
                IBoundInstanceModelGroupedNamed actualInstance = instance.getGroupedModelInstance(nextQName);
                assert (actualInstance != null);
                return (IBoundObject)actualInstance.readItem(parent, this);
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
    }

    private final class ModelInstanceReadHandler<ITEM>
    extends AbstractModelInstanceReadHandler<ITEM> {
        private ModelInstanceReadHandler(@NonNull IBoundInstanceModel<ITEM> instance, IBoundObject parentObject) {
            super(instance, parentObject);
        }

        @Override
        public List<ITEM> readList() throws IOException {
            return (List)ObjectUtils.notNull(this.readCollection());
        }

        @Override
        public Map<String, ITEM> readMap() throws IOException {
            IBoundInstanceModel instance = this.getCollectionInfo().getInstance();
            return (Map)ObjectUtils.notNull((Object)this.readCollection().stream().collect(Collectors.toMap(item -> {
                assert (item != null);
                IBoundInstanceFlag jsonKey = instance.getItemJsonKey(item);
                assert (jsonKey != null);
                return ObjectUtils.requireNonNull((Object)jsonKey.getValue(item)).toString();
            }, Function.identity(), (t, u) -> u, LinkedHashMap::new)));
        }

        @NonNull
        private List<ITEM> readCollection() throws IOException {
            LinkedList<ITEM> retval = new LinkedList<ITEM>();
            try {
                XMLEvent event;
                XmlEventUtil.skipWhitespace((XMLEventReader2)MetaschemaXmlReader.this.reader);
                IBoundInstanceModel instance = this.getCollectionInfo().getInstance();
                while ((event = MetaschemaXmlReader.this.reader.peek()).isStartElement() && instance.canHandleXmlQName((QName)ObjectUtils.notNull((Object)event.asStartElement().getName()))) {
                    ITEM value = this.readItem();
                    retval.add(value);
                    XmlEventUtil.skipWhitespace((XMLEventReader2)MetaschemaXmlReader.this.reader);
                }
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
            return retval;
        }

        @Override
        public ITEM readItem() throws IOException {
            try {
                return (ITEM)this.getCollectionInfo().getInstance().readItem(this.getParentObject(), new ItemReadHandler((StartElement)ObjectUtils.notNull((Object)MetaschemaXmlReader.this.getReader().peek().asStartElement())));
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
    }

    @FunctionalInterface
    private static interface DefinitionBodyHandler<DEF extends IBoundDefinitionModelComplex, ITEM> {
        public void accept(@NonNull DEF var1, @NonNull ITEM var2) throws IOException;
    }

    private static class MetaschemaData
    implements IMetaschemaData {
        private final int line;
        private final int column;
        private final long charOffset;

        public MetaschemaData(@NonNull Location location) {
            this.line = location.getLineNumber();
            this.column = location.getColumnNumber();
            this.charOffset = location.getCharacterOffset();
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public long getCharOffset() {
            return this.charOffset;
        }

        public long getByteOffset() {
            return -1L;
        }
    }
}

