/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.io.yaml;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.json.JSONObject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public final class YamlOperations {
    private static final Yaml YAML_PARSER;

    private YamlOperations() {
    }

    @NonNull
    public static Map<String, Object> parseYaml(URI target) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream((InputStream)ObjectUtils.notNull((Object)target.toURL().openStream()));){
            Map map = (Map)YAML_PARSER.load((InputStream)is);
            return map;
        }
    }

    public static JSONObject yamlToJson(@NonNull Map<String, Object> map) {
        return new JSONObject(map);
    }

    static {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x7FFFFFFE);
        Constructor constructor = new Constructor(loaderOptions);
        DumperOptions dumperOptions = new DumperOptions();
        Representer representer = new Representer(dumperOptions);
        YAML_PARSER = new Yaml((BaseConstructor)constructor, representer, dumperOptions, loaderOptions, new Resolver(){

            protected void addImplicitResolvers() {
                this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
                this.addImplicitResolver(Tag.INT, INT, "-+0123456789");
                this.addImplicitResolver(Tag.FLOAT, FLOAT, "-+0123456789.");
                this.addImplicitResolver(Tag.MERGE, MERGE, "<");
                this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
                this.addImplicitResolver(Tag.NULL, EMPTY, null);
            }
        });
    }
}

