/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.model.AbstractModule;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelField;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.annotations.NsBinding;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public abstract class AbstractBoundModule
extends AbstractModule<IBoundModule, IBoundDefinitionModelComplex, IBoundDefinitionFlag, IBoundDefinitionModelField<?>, IBoundDefinitionModelAssembly>
implements IBoundModule {
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final Lazy<Map<QName, IBoundDefinitionModelAssembly>> assemblyDefinitions;
    @NonNull
    private final Lazy<Map<QName, IBoundDefinitionModelField<?>>> fieldDefinitions;
    @NonNull
    private final Lazy<StaticContext> staticContext;
    @NonNull
    private final ISource source;

    protected AbstractBoundModule(@NonNull List<? extends IBoundModule> importedModules, @NonNull IBindingContext bindingContext) {
        super(importedModules);
        this.bindingContext = bindingContext;
        this.assemblyDefinitions = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> Arrays.stream(this.getAssemblyClasses()).map(clazz -> {
            assert (clazz != null);
            return (IBoundDefinitionModelAssembly)ObjectUtils.requireNonNull((Object)bindingContext.getBoundDefinitionForClass((Class<? extends IBoundObject>)clazz));
        }).collect(Collectors.toUnmodifiableMap(IDefinition::getDefinitionQName, Function.identity()))));
        this.fieldDefinitions = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> Arrays.stream(this.getFieldClasses()).map(clazz -> {
            assert (clazz != null);
            return (IBoundDefinitionModelField)ObjectUtils.requireNonNull((Object)bindingContext.getBoundDefinitionForClass((Class<? extends IBoundObject>)clazz));
        }).collect(Collectors.toUnmodifiableMap(IDefinition::getDefinitionQName, Function.identity()))));
        this.staticContext = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            StaticContext.Builder builder = StaticContext.builder().defaultModelNamespace(this.getXmlNamespace());
            this.getNamespaceBindings().forEach((prefix, ns) -> builder.namespace((String)ObjectUtils.requireNonNull((Object)prefix), (String)ObjectUtils.requireNonNull((Object)ns)));
            return builder.build();
        }));
        this.source = ISource.moduleSource((IModule)this);
    }

    public ISource getSource() {
        return this.source;
    }

    public StaticContext getModuleStaticContext() {
        return (StaticContext)ObjectUtils.notNull((Object)((StaticContext)this.staticContext.get()));
    }

    @Override
    @NonNull
    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public Map<String, String> getNamespaceBindings() {
        return (Map)ObjectUtils.notNull((Object)Arrays.stream(this.getNsBindings()).collect(Collectors.toMap(NsBinding::prefix, NsBinding::uri, (v1, v2) -> v2, LinkedHashMap::new)));
    }

    @NonNull
    protected NsBinding[] getNsBindings() {
        return this.getClass().isAnnotationPresent(MetaschemaModule.class) ? this.getClass().getAnnotation(MetaschemaModule.class).nsBindings() : (NsBinding[])Array.newInstance(NsBinding.class, 0);
    }

    @NonNull
    protected Class<? extends IBoundObject>[] getAssemblyClasses() {
        return this.getClass().isAnnotationPresent(MetaschemaModule.class) ? this.getClass().getAnnotation(MetaschemaModule.class).assemblies() : (Class[])Array.newInstance(Class.class, 0);
    }

    @NonNull
    protected Class<? extends IBoundObject>[] getFieldClasses() {
        return this.getClass().isAnnotationPresent(MetaschemaModule.class) ? this.getClass().getAnnotation(MetaschemaModule.class).fields() : (Class[])Array.newInstance(Class.class, 0);
    }

    protected Map<QName, IBoundDefinitionModelAssembly> getAssemblyDefinitionMap() {
        return (Map)this.assemblyDefinitions.get();
    }

    @Override
    public Collection<IBoundDefinitionModelAssembly> getAssemblyDefinitions() {
        return this.getAssemblyDefinitionMap().values();
    }

    @Override
    public IBoundDefinitionModelAssembly getAssemblyDefinitionByName(@NonNull QName name) {
        return this.getAssemblyDefinitionMap().get(name);
    }

    protected Map<QName, IBoundDefinitionModelField<?>> getFieldDefinitionMap() {
        return (Map)this.fieldDefinitions.get();
    }

    @Override
    public Collection<IBoundDefinitionModelField<?>> getFieldDefinitions() {
        return this.getFieldDefinitionMap().values();
    }

    @Override
    public IBoundDefinitionModelField<?> getFieldDefinitionByName(@NonNull QName name) {
        return this.getFieldDefinitionMap().get(name);
    }

    public Collection<IBoundDefinitionFlag> getFlagDefinitions() {
        return Collections.emptyList();
    }

    public IBoundDefinitionFlag getFlagDefinitionByName(@NonNull QName name) {
        return null;
    }
}

