/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.info.IFeatureComplexItemValueHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.Predicate;

public interface IBoundDefinitionModelComplex
extends IBoundDefinitionModel<IBoundObject>,
IFeatureComplexItemValueHandler {
    @NonNull
    public Map<String, IBoundProperty<?>> getJsonProperties(@Nullable Predicate<IBoundInstanceFlag> var1);

    @Nullable
    public Method getBeforeDeserializeMethod();

    @Override
    default public void callBeforeDeserialize(IBoundObject targetObject, IBoundObject parentObject) throws BindingException {
        Method beforeDeserializeMethod = this.getBeforeDeserializeMethod();
        if (beforeDeserializeMethod != null) {
            try {
                beforeDeserializeMethod.invoke((Object)targetObject, parentObject);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new BindingException(ex);
            }
        }
    }

    @Nullable
    public Method getAfterDeserializeMethod();

    @Override
    default public void callAfterDeserialize(IBoundObject targetObject, IBoundObject parentObject) throws BindingException {
        Method afterDeserializeMethod = this.getAfterDeserializeMethod();
        if (afterDeserializeMethod != null) {
            try {
                afterDeserializeMethod.invoke((Object)targetObject, parentObject);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new BindingException(ex);
            }
        }
    }
}

