/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IJsonNamed;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelField;
import gov.nist.secauto.metaschema.databind.model.IBoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.info.IItemReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IItemWriteHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;

public interface IBoundDefinitionModelFieldComplex
extends IBoundDefinitionModelField<IBoundObject>,
IBoundDefinitionModelComplex {
    @Override
    @NonNull
    default public IBoundDefinitionModelFieldComplex getDefinition() {
        return this;
    }

    default public Object getDefaultValue() {
        IBoundObject retval = null;
        IBoundDefinitionModelFieldComplex definition = this.getDefinition();
        IBoundFieldValue fieldValue = definition.getFieldValue();
        Object fieldValueDefault = fieldValue.getDefaultValue();
        if (fieldValueDefault != null) {
            retval = definition.newInstance(null);
            fieldValue.setValue((Object)retval, fieldValueDefault);
            for (IBoundInstanceFlag flag : definition.getFlagInstances()) {
                Object flagDefault = flag.getResolvedDefaultValue();
                if (flagDefault == null) continue;
                flag.setValue(retval, flagDefault);
            }
        }
        return retval;
    }

    @NonNull
    public IBoundFieldValue getFieldValue();

    @NonNull
    default public Object getFieldValue(@NonNull Object item) {
        return ObjectUtils.requireNonNull((Object)this.getFieldValue().getValue(item));
    }

    @NonNull
    default public String getJsonValueKeyName() {
        return this.getFieldValue().getJsonValueKeyName();
    }

    @NonNull
    default public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.getFieldValue().getJavaTypeAdapter();
    }

    @Override
    @NonNull
    default public Map<String, IBoundProperty<?>> getJsonProperties(@Nullable Predicate<IBoundInstanceFlag> flagFilter) {
        Predicate<IBoundInstanceFlag> actualFlagFilter = flagFilter;
        IBoundFieldValue fieldValue = this.getFieldValue();
        IBoundInstanceFlag jsonValueKey = this.getDefinition().getJsonValueKeyFlagInstance();
        if (jsonValueKey != null) {
            Predicate<IBoundInstanceFlag> jsonValueKeyFilter = flag -> !flag.equals(jsonValueKey);
            actualFlagFilter = actualFlagFilter == null ? jsonValueKeyFilter : actualFlagFilter.and(jsonValueKeyFilter);
            fieldValue = null;
        }
        Stream<Object> flagStream = this.getFlagInstances().stream();
        if (actualFlagFilter != null) {
            flagStream = flagStream.filter(actualFlagFilter);
        }
        if (fieldValue != null) {
            Collection flagInstances = flagStream.collect(Collectors.toList());
            if (flagInstances.isEmpty()) {
                fieldValue = null;
            }
            flagStream = flagInstances.stream();
        }
        Stream<Object> resultStream = fieldValue == null ? flagStream : Stream.concat(flagStream, Stream.of(this.getFieldValue()));
        return (Map)ObjectUtils.notNull(resultStream.collect(Collectors.toUnmodifiableMap(IJsonNamed::getJsonName, Function.identity())));
    }

    @Override
    @NonNull
    default public IBoundObject readItem(IBoundObject parent, IItemReadHandler handler) throws IOException {
        return handler.readItemField(parent, this);
    }

    @Override
    default public void writeItem(IBoundObject item, IItemWriteHandler handler) throws IOException {
        handler.writeItemField(item, this);
    }

    @Override
    default public boolean canHandleXmlQName(QName qname) {
        return false;
    }
}

