/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceAbsolute;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelNamed;
import gov.nist.secauto.metaschema.databind.model.impl.DefinitionField;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.impl.InstanceModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.impl.InstanceModelFieldScalar;
import java.lang.reflect.Field;
import javax.xml.namespace.QName;

public interface IBoundInstanceModelField<ITEM>
extends IBoundInstanceModelNamed<ITEM>,
IFieldInstanceAbsolute {
    @Override
    public IBoundDefinitionModelField<ITEM> getDefinition();

    @NonNull
    public static IBoundInstanceModelField<?> newInstance(@NonNull Field field, @NonNull IBoundDefinitionModelAssembly containingDefinition) {
        IFeatureInstanceModelGroupAs<Object> retval;
        Class<?> itemType = IBoundInstanceModel.getItemType(field);
        if (IBoundObject.class.isAssignableFrom(itemType)) {
            IBindingContext bindingContext = containingDefinition.getBindingContext();
            IBoundDefinitionModelComplex definition = bindingContext.getBoundDefinitionForClass((Class)ObjectUtils.notNull(itemType.asSubclass(IBoundObject.class)));
            if (definition == null) {
                throw new IllegalStateException(String.format("The field '%s' on class '%s' is not bound to a Metaschema field", field.toString(), field.getDeclaringClass().getName()));
            }
            retval = InstanceModelFieldComplex.newInstance(field, (DefinitionField)definition, containingDefinition);
        } else {
            retval = InstanceModelFieldScalar.newInstance(field, containingDefinition);
        }
        return retval;
    }

    @Override
    default public boolean canHandleXmlQName(QName qname) {
        boolean retval;
        if (this.isEffectiveValueWrappedInXml()) {
            retval = qname.equals(this.getXmlQName());
        } else {
            IDataTypeAdapter adapter = this.getDefinition().getJavaTypeAdapter();
            retval = adapter.canHandleQName(qname);
        }
        return retval;
    }
}

