/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedNamed;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundGroupedField;
import gov.nist.secauto.metaschema.databind.model.impl.DefinitionField;
import gov.nist.secauto.metaschema.databind.model.impl.InstanceModelGroupedFieldComplex;
import gov.nist.secauto.metaschema.databind.model.info.IItemReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IItemWriteHandler;
import java.io.IOException;
import java.lang.reflect.Field;

public interface IBoundInstanceModelGroupedField
extends IBoundInstanceModelGroupedNamed,
IFieldInstanceGrouped {
    @NonNull
    public static IBoundInstanceModelGroupedField newInstance(@NonNull BoundGroupedField annotation, @NonNull IBoundInstanceModelChoiceGroup container) {
        Class<? extends IBoundObject> clazz = annotation.binding();
        IBindingContext bindingContext = container.getContainingDefinition().getBindingContext();
        IBoundDefinitionModelComplex definition = bindingContext.getBoundDefinitionForClass(clazz);
        if (!(definition instanceof DefinitionField)) {
            Field field = container.getField();
            throw new IllegalStateException(String.format("The '%s' annotation, bound to '%s', field '%s' on class '%s' is not bound to a Metaschema field", annotation.getClass(), annotation.binding().getName(), field.toString(), field.getDeclaringClass().getName()));
        }
        return new InstanceModelGroupedFieldComplex(annotation, (DefinitionField)definition, container);
    }

    @Override
    public IBoundDefinitionModelFieldComplex getDefinition();

    @Override
    default public IBoundObject readItem(IBoundObject parent, @NonNull IItemReadHandler handler) throws IOException {
        return handler.readItemField((IBoundObject)ObjectUtils.requireNonNull((Object)parent, (String)"parent"), this);
    }

    @Override
    default public void writeItem(IBoundObject item, IItemWriteHandler handler) throws IOException {
        handler.writeItemField(item, this);
    }
}

