/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.databind.model.IValuedMutable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

public interface IFeatureJavaField
extends IValuedMutable {
    @NonNull
    public Field getField();

    @NonNull
    default public Type getType() {
        return this.getField().getGenericType();
    }

    @NonNull
    default public Class<?> getItemType() {
        return (Class)this.getType();
    }

    default public Object getValue(@NonNull Object parent) {
        Object retval;
        Field field = this.getField();
        boolean accessable = field.canAccess(parent);
        field.setAccessible(true);
        try {
            Object result;
            retval = result = field.get(parent);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to get the value of field '%s' in class '%s'.", field.getName(), field.getDeclaringClass().getName()), ex);
        }
        finally {
            field.setAccessible(accessable);
        }
        return retval;
    }

    @Override
    default public void setValue(@NonNull Object parentObject, Object value) {
        Field field = this.getField();
        boolean accessable = field.canAccess(parentObject);
        field.setAccessible(true);
        try {
            field.set(parentObject, value);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unable to set the value of field '%s' in class '%s'. Perhaps this is a data type adapter problem on the declared class?", field.getName(), field.getDeclaringClass().getName()), ex);
        }
        finally {
            field.setAccessible(accessable);
        }
    }
}

