/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.annotations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.NullJavaTypeAdapter;
import gov.nist.secauto.metaschema.databind.model.annotations.Property;
import gov.nist.secauto.metaschema.databind.model.impl.DefaultGroupAs;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModelUtil {
    public static final String NO_STRING_VALUE = "##none";
    public static final String DEFAULT_STRING_VALUE = "##default";
    public static final String NULL_VALUE = "\u0000";

    private ModelUtil() {
    }

    @NonNull
    public static <A extends Annotation> A getAnnotation(@NonNull Class<?> clazz, Class<A> annotationClass) {
        A annotation = clazz.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing the '%s' annotation.", clazz.getName(), annotationClass.getName()));
        }
        return annotation;
    }

    @NonNull
    public static <A extends Annotation> A getAnnotation(@NonNull Field javaField, Class<A> annotationClass) {
        A annotation = javaField.getAnnotation(annotationClass);
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Field '%s' is missing the '%s' annotation.", javaField.toGenericString(), annotationClass.getName()));
        }
        return annotation;
    }

    @Nullable
    public static String resolveNoneOrDefault(@Nullable String value, @Nullable String defaultValue) {
        Object retval = value == null || DEFAULT_STRING_VALUE.equals(value) ? defaultValue : (NO_STRING_VALUE.equals(value) ? null : value);
        return retval;
    }

    @Nullable
    public static String resolveNoneOrValue(@NonNull String value) {
        return NO_STRING_VALUE.equals(value) ? null : value;
    }

    @Nullable
    public static MarkupLine resolveToMarkupLine(@NonNull String value) {
        return ModelUtil.resolveNoneOrValue(value) == null ? null : MarkupLine.fromMarkdown((String)value);
    }

    @Nullable
    public static MarkupMultiline resolveToMarkupMultiline(@NonNull String value) {
        return ModelUtil.resolveNoneOrValue(value) == null ? null : MarkupMultiline.fromMarkdown((String)value);
    }

    @NonNull
    public static IDataTypeAdapter<?> getDataTypeAdapter(@NonNull Class<? extends IDataTypeAdapter<?>> adapterClass, @NonNull IBindingContext bindingContext) {
        IDataTypeAdapter<?> retval;
        if (NullJavaTypeAdapter.class.equals(adapterClass)) {
            retval = MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
        } else {
            retval = bindingContext.getJavaTypeAdapterInstance(adapterClass);
            if (retval == null) {
                throw new IllegalArgumentException("Unable to get type adapter instance for class: " + adapterClass.getName());
            }
        }
        return retval;
    }

    @Nullable
    public static Object resolveDefaultValue(@NonNull String defaultValue, IDataTypeAdapter<?> adapter) {
        Object retval = null;
        if (!NULL_VALUE.equals(defaultValue)) {
            retval = adapter.parse(defaultValue);
        }
        return retval;
    }

    public static Integer resolveDefaultInteger(int value) {
        return value == Integer.MIN_VALUE ? null : Integer.valueOf(value);
    }

    @NonNull
    public static IGroupAs resolveDefaultGroupAs(@NonNull GroupAs groupAs, @NonNull IModule module) {
        return NULL_VALUE.equals(groupAs.name()) ? IGroupAs.SINGLETON_GROUP_AS : new DefaultGroupAs(groupAs, module);
    }

    public static String toLocation(@NonNull IBoundObject obj) {
        int line;
        IMetaschemaData data = obj.getMetaschemaData();
        Object retval = "";
        if (data != null && (line = data.getLine()) > -1) {
            retval = line + ":" + data.getColumn();
        }
        return retval;
    }

    public static String toLocation(@NonNull IBoundObject obj, @Nullable URI uri) {
        String retval = uri == null ? "" : uri.toASCIIString();
        String location = ModelUtil.toLocation(obj);
        if (!location.isEmpty()) {
            retval = retval.isEmpty() ? location : retval + "@" + location;
        }
        return retval;
    }

    public static Map.Entry<IAttributable.Key, Set<String>> toPropertyEntry(@NonNull Property property) {
        String name = property.name();
        String namespace = property.namespace();
        IAttributable.Key key = IAttributable.key((String)namespace, (String)name);
        String[] values = property.values();
        List<String> valueList = Arrays.asList(values);
        LinkedHashSet<String> valueSet = new LinkedHashSet<String>(valueList);
        return Map.entry(key, CollectionUtil.unmodifiableSet(valueSet));
    }
}

