/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.impl.ClassIntrospector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public abstract class AbstractBoundDefinitionModelComplex<A extends Annotation>
implements IBoundDefinitionModelComplex {
    @NonNull
    private final Class<? extends IBoundObject> clazz;
    @NonNull
    private final A annotation;
    @NonNull
    private final IBindingContext bindingContext;
    @NonNull
    private final IBoundModule module;
    @NonNull
    private final Lazy<QName> qname;
    @NonNull
    private final Lazy<QName> definitionQName;
    @Nullable
    private final Method beforeDeserializeMethod;
    @Nullable
    private final Method afterDeserializeMethod;

    protected AbstractBoundDefinitionModelComplex(@NonNull Class<? extends IBoundObject> clazz, @NonNull A annotation, @NonNull IBoundModule module, @NonNull IBindingContext bindingContext) {
        this.clazz = clazz;
        this.annotation = annotation;
        this.bindingContext = bindingContext;
        this.module = module;
        this.qname = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> this.getContainingModule().toModelQName(this.getEffectiveName())));
        this.definitionQName = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> this.getContainingModule().toModelQName(this.getName())));
        this.beforeDeserializeMethod = ClassIntrospector.getMatchingMethod(clazz, "beforeDeserialize", Object.class);
        this.afterDeserializeMethod = ClassIntrospector.getMatchingMethod(clazz, "afterDeserialize", Object.class);
    }

    @Override
    public Class<? extends IBoundObject> getBoundClass() {
        return this.clazz;
    }

    @NonNull
    public A getAnnotation() {
        return this.annotation;
    }

    @Override
    @NonNull
    public IBoundModule getContainingModule() {
        return this.module;
    }

    @Override
    @NonNull
    public IBindingContext getBindingContext() {
        return this.bindingContext;
    }

    public final QName getXmlQName() {
        return (QName)this.qname.get();
    }

    public final QName getDefinitionQName() {
        return (QName)this.definitionQName.get();
    }

    @Override
    public Method getBeforeDeserializeMethod() {
        return this.beforeDeserializeMethod;
    }

    @Override
    public Method getAfterDeserializeMethod() {
        return this.afterDeserializeMethod;
    }

    @Override
    public IBoundObject deepCopyItem(IBoundObject item, IBoundObject parentInstance) throws BindingException {
        IBoundObject instance = this.newInstance(() -> ((IBoundObject)item).getMetaschemaData());
        this.callBeforeDeserialize(instance, parentInstance);
        this.deepCopyItemInternal(item, instance);
        this.callAfterDeserialize(instance, parentInstance);
        return instance;
    }

    protected void deepCopyItemInternal(@NonNull IBoundObject fromObject, @NonNull IBoundObject toObject) throws BindingException {
        for (IBoundInstanceFlag instance : this.getFlagInstances()) {
            instance.deepCopy(fromObject, toObject);
        }
    }
}

