/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IChoiceInstance;
import gov.nist.secauto.metaschema.core.model.IContainerModelAssemblySupport;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelNamed;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.Ignore;
import gov.nist.secauto.metaschema.databind.model.impl.DefinitionAssembly;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;

class AssemblyModelContainerSupport
implements IContainerModelAssemblySupport<IBoundInstanceModel<?>, IBoundInstanceModelNamed<?>, IBoundInstanceModelField<?>, IBoundInstanceModelAssembly, IChoiceInstance, IBoundInstanceModelChoiceGroup> {
    @NonNull
    private final List<IBoundInstanceModel<?>> modelInstances;
    @NonNull
    private final Map<QName, IBoundInstanceModelNamed<?>> namedModelInstances;
    @NonNull
    private final Map<QName, IBoundInstanceModelField<?>> fieldInstances;
    @NonNull
    private final Map<QName, IBoundInstanceModelAssembly> assemblyInstances;
    @NonNull
    private final Map<String, IBoundInstanceModelChoiceGroup> choiceGroupInstances;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public AssemblyModelContainerSupport(@NonNull DefinitionAssembly containingDefinition) {
        this.modelInstances = CollectionUtil.unmodifiableList((List)((List)ObjectUtils.notNull(AssemblyModelContainerSupport.getModelInstanceStream(containingDefinition, containingDefinition.getBoundClass()).collect(Collectors.toUnmodifiableList()))));
        LinkedHashMap<QName, IBoundInstanceModelNamed> namedModelInstances = new LinkedHashMap<QName, IBoundInstanceModelNamed>();
        LinkedHashMap<Object, IBoundInstanceModelField> fieldInstances = new LinkedHashMap<Object, IBoundInstanceModelField>();
        LinkedHashMap<Object, IBoundInstanceModelAssembly> assemblyInstances = new LinkedHashMap<Object, IBoundInstanceModelAssembly>();
        LinkedHashMap<Object, IBoundInstanceModelChoiceGroup> choiceGroupInstances = new LinkedHashMap<Object, IBoundInstanceModelChoiceGroup>();
        for (IBoundInstanceModel<?> instance : this.modelInstances) {
            Object key;
            if (instance instanceof IBoundInstanceModelNamed) {
                IBoundInstanceModelNamed named = (IBoundInstanceModelNamed)instance;
                key = named.getXmlQName();
                namedModelInstances.put((QName)key, named);
                if (instance instanceof IBoundInstanceModelField) {
                    fieldInstances.put(key, (IBoundInstanceModelField)named);
                    continue;
                }
                if (!(instance instanceof IBoundInstanceModelAssembly)) continue;
                assemblyInstances.put(key, (IBoundInstanceModelAssembly)named);
                continue;
            }
            if (!(instance instanceof IBoundInstanceModelChoiceGroup)) continue;
            IBoundInstanceModelChoiceGroup choiceGroup = (IBoundInstanceModelChoiceGroup)instance;
            key = (String)ObjectUtils.requireNonNull((Object)choiceGroup.getGroupAsName());
            choiceGroupInstances.put(key, choiceGroup);
        }
        this.namedModelInstances = namedModelInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(namedModelInstances);
        this.fieldInstances = fieldInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(fieldInstances);
        this.assemblyInstances = assemblyInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(assemblyInstances);
        this.choiceGroupInstances = choiceGroupInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(choiceGroupInstances);
    }

    protected static IBoundInstanceModel<?> newBoundModelInstance(@NonNull Field field, @NonNull IBoundDefinitionModelAssembly definition) {
        IBoundInstanceModel<IBoundObject> retval = null;
        if (field.isAnnotationPresent(BoundAssembly.class)) {
            retval = IBoundInstanceModelAssembly.newInstance(field, definition);
        } else if (field.isAnnotationPresent(BoundField.class)) {
            retval = IBoundInstanceModelField.newInstance(field, definition);
        } else if (field.isAnnotationPresent(BoundChoiceGroup.class)) {
            retval = IBoundInstanceModelChoiceGroup.newInstance(field, definition);
        }
        return retval;
    }

    @NonNull
    protected static Stream<IBoundInstanceModel<?>> getModelInstanceStream(@NonNull IBoundDefinitionModelAssembly definition, @NonNull Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        Stream<Object> superInstances = superClass == null ? Stream.empty() : AssemblyModelContainerSupport.getModelInstanceStream(definition, superClass);
        return (Stream)ObjectUtils.notNull(Stream.concat(superInstances, Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isAnnotationPresent(Ignore.class)).filter(field -> field.isAnnotationPresent(BoundField.class) || field.isAnnotationPresent(BoundAssembly.class) || field.isAnnotationPresent(BoundChoiceGroup.class)).map(field -> {
            assert (field != null);
            IBoundInstanceModel<?> retval = AssemblyModelContainerSupport.newBoundModelInstance(field, definition);
            if (retval == null) {
                throw new IllegalStateException(String.format("The field '%s' on class '%s' is not bound", field.getName(), clazz.getName()));
            }
            return retval;
        }).filter(Objects::nonNull)));
    }

    public Collection<IBoundInstanceModel<?>> getModelInstances() {
        return this.modelInstances;
    }

    public Map<QName, IBoundInstanceModelNamed<?>> getNamedModelInstanceMap() {
        return this.namedModelInstances;
    }

    public Map<QName, IBoundInstanceModelField<?>> getFieldInstanceMap() {
        return this.fieldInstances;
    }

    public Map<QName, IBoundInstanceModelAssembly> getAssemblyInstanceMap() {
        return this.assemblyInstances;
    }

    public List<IChoiceInstance> getChoiceInstances() {
        return CollectionUtil.emptyList();
    }

    public Map<String, IBoundInstanceModelChoiceGroup> getChoiceGroupInstanceMap() {
        return this.choiceGroupInstances;
    }
}

