/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.DataTypeService;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractConfigurableMessageConstraintBuilder;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractConstraintBuilder;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractKeyConstraintBuilder;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IKeyField;
import gov.nist.secauto.metaschema.core.model.constraint.ILet;
import gov.nist.secauto.metaschema.core.model.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.HasCardinality;
import gov.nist.secauto.metaschema.databind.model.annotations.Index;
import gov.nist.secauto.metaschema.databind.model.annotations.IndexHasKey;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Let;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.annotations.NullJavaTypeAdapter;
import gov.nist.secauto.metaschema.databind.model.annotations.Property;
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

final class ConstraintFactory {
    private ConstraintFactory() {
    }

    static MarkupMultiline toRemarks(@NonNull String remarks) {
        return remarks.isBlank() ? null : MarkupMultiline.fromMarkdown((String)remarks);
    }

    @NonNull
    static String toMetapath(@NonNull String metapath) {
        return metapath.isBlank() ? "." : metapath;
    }

    @NonNull
    static <T extends AbstractConstraintBuilder<T, ?>> T applyId(@NonNull T builder, @NonNull String id) {
        if (!id.isBlank()) {
            builder.identifier(id);
        }
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraintBuilder<T, ?>> T applyFormalName(@NonNull T builder, @NonNull String name) {
        if (!name.isBlank()) {
            builder.formalName(name);
        }
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraintBuilder<T, ?>> T applyDescription(@NonNull T builder, @NonNull String value) {
        if (!value.isBlank()) {
            builder.description(MarkupLine.fromMarkdown((String)value));
        }
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraintBuilder<T, ?>> T applyTarget(@NonNull T builder, @NonNull String target) {
        builder.target(ConstraintFactory.toMetapath(target));
        return builder;
    }

    @NonNull
    static <T extends AbstractConstraintBuilder<T, ?>> T applyProperties(@NonNull T builder, Property ... properties) {
        if (properties != null) {
            Arrays.stream(properties).map(ModelUtil::toPropertyEntry).forEachOrdered(entry -> builder.property((IAttributable.Key)ObjectUtils.notNull((Object)((IAttributable.Key)entry.getKey())), (Set)ObjectUtils.notNull((Object)((Set)entry.getValue()))));
        }
        return builder;
    }

    static <T extends AbstractConfigurableMessageConstraintBuilder<T, ?>> T applyMessage(@NonNull T builder, @Nullable String message) {
        if (message != null && !message.isBlank()) {
            builder.message(message);
        }
        return builder;
    }

    static <T extends AbstractConstraintBuilder<T, ?>> T applyRemarks(@NonNull T builder, @NonNull String remarks) {
        if (!remarks.isBlank()) {
            builder.remarks(MarkupMultiline.fromMarkdown((String)remarks));
        }
        return builder;
    }

    @NonNull
    static IAllowedValuesConstraint.Builder applyAllowedValues(@NonNull IAllowedValuesConstraint.Builder builder, @NonNull AllowedValues constraint) {
        for (AllowedValue value : constraint.values()) {
            String deprecatedVersion = value.deprecatedVersion();
            if (deprecatedVersion.isBlank()) {
                deprecatedVersion = null;
            }
            IAllowedValue allowedValue = IAllowedValue.of((String)value.value(), (MarkupLine)MarkupLine.fromMarkdown((String)value.description()), (String)deprecatedVersion);
            builder.allowedValue(allowedValue);
        }
        return builder;
    }

    @Nullable
    static Pattern toPattern(@NonNull String pattern) {
        return pattern.isBlank() ? null : Pattern.compile(pattern);
    }

    @Nullable
    static String toMessage(@NonNull String message) {
        return message.isBlank() ? null : message;
    }

    @Nullable
    static IDataTypeAdapter<?> toDataType(@NonNull Class<? extends IDataTypeAdapter<?>> adapterClass) {
        return adapterClass.isAssignableFrom(NullJavaTypeAdapter.class) ? null : DataTypeService.getInstance().getJavaTypeAdapterByClass(adapterClass);
    }

    @NonNull
    static IAllowedValuesConstraint newAllowedValuesConstraint(@NonNull AllowedValues constraint, @NonNull ISource source) {
        IAllowedValuesConstraint.Builder builder = IAllowedValuesConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((IAllowedValuesConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        ConstraintFactory.applyAllowedValues(builder, constraint);
        builder.allowsOther(constraint.allowOthers());
        builder.extensible(constraint.extensible());
        return (IAllowedValuesConstraint)builder.build();
    }

    @NonNull
    static IMatchesConstraint newMatchesConstraint(Matches constraint, @NonNull ISource source) {
        IDataTypeAdapter<?> dataType;
        IMatchesConstraint.Builder builder = IMatchesConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((IMatchesConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyMessage(builder, constraint.message());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        Pattern pattern = ConstraintFactory.toPattern(constraint.pattern());
        if (pattern != null) {
            builder.regex(pattern);
        }
        if ((dataType = ConstraintFactory.toDataType(constraint.typeAdapter())) != null) {
            builder.datatype(dataType);
        }
        return (IMatchesConstraint)builder.build();
    }

    @NonNull
    static <T extends AbstractKeyConstraintBuilder<T, ?>> T applyKeyFields(@NonNull T builder, @NonNull ISource source, KeyField ... keyFields) {
        for (KeyField keyField : keyFields) {
            IKeyField field = IKeyField.of((String)ConstraintFactory.toMetapath(keyField.target()), (Pattern)ConstraintFactory.toPattern(keyField.pattern()), (MarkupMultiline)ConstraintFactory.toRemarks(keyField.remarks()), (ISource)source);
            builder.keyField(field);
        }
        return builder;
    }

    @NonNull
    static IUniqueConstraint newUniqueConstraint(@NonNull IsUnique constraint, @NonNull ISource source) {
        IUniqueConstraint.Builder builder = IUniqueConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((IUniqueConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyMessage(builder, constraint.message());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        ConstraintFactory.applyKeyFields(builder, source, constraint.keyFields());
        return (IUniqueConstraint)builder.build();
    }

    @NonNull
    static IIndexConstraint newIndexConstraint(@NonNull Index constraint, @NonNull ISource source) {
        IIndexConstraint.Builder builder = IIndexConstraint.builder((String)constraint.name());
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((IIndexConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyMessage(builder, constraint.message());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        ConstraintFactory.applyKeyFields(builder, source, constraint.keyFields());
        return (IIndexConstraint)builder.build();
    }

    @NonNull
    static IIndexHasKeyConstraint newIndexHasKeyConstraint(@NonNull IndexHasKey constraint, @NonNull ISource source) {
        IIndexHasKeyConstraint.Builder builder = IIndexHasKeyConstraint.builder((String)constraint.indexName());
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((IIndexHasKeyConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyMessage(builder, constraint.message());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        ConstraintFactory.applyKeyFields(builder, source, constraint.keyFields());
        return (IIndexHasKeyConstraint)builder.build();
    }

    @NonNull
    static IExpectConstraint newExpectConstraint(@NonNull Expect constraint, @NonNull ISource source) {
        IExpectConstraint.Builder builder = IExpectConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((IExpectConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyMessage(builder, constraint.message());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        builder.test(ConstraintFactory.toMetapath(constraint.test()));
        return (IExpectConstraint)builder.build();
    }

    @Nullable
    static Integer toCardinality(int value) {
        return value < 0 ? null : Integer.valueOf(value);
    }

    @NonNull
    static ICardinalityConstraint newCardinalityConstraint(@NonNull HasCardinality constraint, @NonNull ISource source) {
        Integer max;
        ICardinalityConstraint.Builder builder = ICardinalityConstraint.builder();
        ConstraintFactory.applyId(builder, constraint.id());
        ConstraintFactory.applyFormalName(builder, constraint.formalName());
        ConstraintFactory.applyDescription(builder, constraint.description());
        ((ICardinalityConstraint.Builder)builder.source(source)).level(constraint.level());
        ConstraintFactory.applyTarget(builder, constraint.target());
        ConstraintFactory.applyProperties(builder, constraint.properties());
        ConstraintFactory.applyMessage(builder, constraint.message());
        ConstraintFactory.applyRemarks(builder, constraint.remarks());
        Integer min = ConstraintFactory.toCardinality(constraint.minOccurs());
        if (min != null) {
            builder.minOccurs(min.intValue());
        }
        if ((max = ConstraintFactory.toCardinality(constraint.maxOccurs())) != null) {
            builder.maxOccurs(max.intValue());
        }
        return (ICardinalityConstraint)builder.build();
    }

    @NonNull
    static ILet newLetExpression(@NonNull Let annotation, @NonNull ISource source) {
        String remarkMarkdown = annotation.remarks();
        MarkupMultiline remarks = remarkMarkdown.isBlank() ? null : MarkupMultiline.fromMarkdown((String)remarkMarkdown);
        return ILet.of((QName)new QName(annotation.name()), (String)annotation.target(), (ISource)source, (MarkupMultiline)remarks);
    }
}

