/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.model.constraint.IModelConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.impl.ConstraintFactory;
import java.util.Arrays;

public final class ConstraintSupport {
    private ConstraintSupport() {
    }

    public static void parse(@Nullable ValueConstraints valueAnnotation, @NonNull ISource source, @NonNull IValueConstrained set) {
        if (valueAnnotation != null) {
            try {
                Arrays.stream(valueAnnotation.lets()).map(annotation -> ConstraintFactory.newLetExpression(annotation, source)).forEachOrdered(arg_0 -> ((IValueConstrained)set).addLetExpression(arg_0));
                Arrays.stream(valueAnnotation.allowedValues()).map(annotation -> ConstraintFactory.newAllowedValuesConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IValueConstrained)set).addConstraint(arg_0));
                Arrays.stream(valueAnnotation.matches()).map(annotation -> ConstraintFactory.newMatchesConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IValueConstrained)set).addConstraint(arg_0));
                Arrays.stream(valueAnnotation.indexHasKey()).map(annotation -> ConstraintFactory.newIndexHasKeyConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IValueConstrained)set).addConstraint(arg_0));
                Arrays.stream(valueAnnotation.expect()).map(annotation -> ConstraintFactory.newExpectConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IValueConstrained)set).addConstraint(arg_0));
            }
            catch (MetapathException ex) {
                throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), (Throwable)ex);
            }
        }
    }

    public static void parse(@Nullable AssemblyConstraints assemblyAnnotation, @NonNull ISource source, @NonNull IModelConstrained set) {
        if (assemblyAnnotation != null) {
            try {
                Arrays.stream(assemblyAnnotation.index()).map(annotation -> ConstraintFactory.newIndexConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IModelConstrained)set).addConstraint(arg_0));
                Arrays.stream(assemblyAnnotation.unique()).map(annotation -> ConstraintFactory.newUniqueConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IModelConstrained)set).addConstraint(arg_0));
                Arrays.stream(assemblyAnnotation.cardinality()).map(annotation -> ConstraintFactory.newCardinalityConstraint(annotation, source)).forEachOrdered(arg_0 -> ((IModelConstrained)set).addConstraint(arg_0));
            }
            catch (MetapathException ex) {
                throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), (Throwable)ex);
            }
        }
    }
}

