/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.model.constraint.AssemblyConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.IModelConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelNamed;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.impl.AbstractBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.impl.AssemblyModelContainerSupport;
import gov.nist.secauto.metaschema.databind.model.impl.ConstraintSupport;
import gov.nist.secauto.metaschema.databind.model.impl.FlagContainerSupport;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureBoundContainerModelAssembly;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public final class DefinitionAssembly
extends AbstractBoundDefinitionModelComplex<MetaschemaAssembly>
implements IBoundDefinitionModelAssembly,
IFeatureBoundContainerModelAssembly<IBoundInstanceModel<?>, IBoundInstanceModelNamed<?>, IBoundInstanceModelField<?>, IBoundInstanceModelAssembly, IBoundInstanceModelChoiceGroup> {
    @NonNull
    private final Lazy<FlagContainerSupport> flagContainer;
    @NonNull
    private final Lazy<AssemblyModelContainerSupport> modelContainer;
    @NonNull
    private final Lazy<IModelConstrained> constraints;
    @NonNull
    private final Lazy<QName> xmlRootQName;
    @NonNull
    private final Lazy<Map<String, IBoundProperty<?>>> jsonProperties;
    @NonNull
    private final Lazy<Map<IAttributable.Key, Set<String>>> properties;

    @NonNull
    public static DefinitionAssembly newInstance(@NonNull Class<? extends IBoundObject> clazz, @NonNull MetaschemaAssembly annotation, @NonNull IBoundModule module, @NonNull IBindingContext bindingContext) {
        return new DefinitionAssembly(clazz, annotation, module, bindingContext);
    }

    private DefinitionAssembly(@NonNull Class<? extends IBoundObject> clazz, @NonNull MetaschemaAssembly annotation, @NonNull IBoundModule module, @NonNull IBindingContext bindingContext) {
        super(clazz, annotation, module, bindingContext);
        String rootLocalName = ModelUtil.resolveNoneOrDefault(((MetaschemaAssembly)this.getAnnotation()).rootName(), null);
        this.xmlRootQName = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> rootLocalName == null ? null : this.getContainingModule().toModelQName(rootLocalName)));
        this.flagContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> new FlagContainerSupport(this, null)));
        this.modelContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> new AssemblyModelContainerSupport(this)));
        ISource moduleSource = module.getSource();
        this.constraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            AssemblyConstraintSet retval = new AssemblyConstraintSet();
            ValueConstraints valueAnnotation = ((MetaschemaAssembly)this.getAnnotation()).valueConstraints();
            ConstraintSupport.parse(valueAnnotation, moduleSource, (IValueConstrained)retval);
            AssemblyConstraints assemblyAnnotation = ((MetaschemaAssembly)this.getAnnotation()).modelConstraints();
            ConstraintSupport.parse(assemblyAnnotation, moduleSource, (IModelConstrained)retval);
            return retval;
        }));
        this.jsonProperties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> this.getJsonProperties(null)));
        this.properties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(annotation.properties()).map(ModelUtil::toPropertyEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new)))))));
    }

    @Override
    protected void deepCopyItemInternal(IBoundObject fromObject, IBoundObject toObject) throws BindingException {
        super.deepCopyItemInternal(fromObject, toObject);
        for (IBoundInstanceModel instance : this.getModelInstances()) {
            instance.deepCopy(fromObject, toObject);
        }
    }

    @Override
    public Map<String, IBoundProperty<?>> getJsonProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.jsonProperties.get()));
    }

    @NonNull
    public FlagContainerSupport getFlagContainer() {
        return (FlagContainerSupport)this.flagContainer.get();
    }

    @NonNull
    public AssemblyModelContainerSupport getModelContainer() {
        return (AssemblyModelContainerSupport)this.modelContainer.get();
    }

    @NonNull
    public IModelConstrained getConstraintSupport() {
        return (IModelConstrained)ObjectUtils.notNull((Object)((IModelConstrained)this.constraints.get()));
    }

    @Nullable
    public String getFormalName() {
        return ModelUtil.resolveNoneOrValue(((MetaschemaAssembly)this.getAnnotation()).formalName());
    }

    @Nullable
    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(((MetaschemaAssembly)this.getAnnotation()).description());
    }

    @NonNull
    public String getName() {
        return ((MetaschemaAssembly)this.getAnnotation()).name();
    }

    @Nullable
    public Integer getIndex() {
        return ModelUtil.resolveDefaultInteger(((MetaschemaAssembly)this.getAnnotation()).index());
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.properties.get()));
    }

    @Nullable
    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(((MetaschemaAssembly)this.getAnnotation()).description());
    }

    @Nullable
    public QName getRootXmlQName() {
        return (QName)this.xmlRootQName.get();
    }

    public boolean isRoot() {
        return this.getRootXmlQName() != null;
    }

    @Nullable
    public String getRootName() {
        QName qname = this.getRootXmlQName();
        return qname == null ? null : qname.getLocalPart();
    }

    @Nullable
    public Integer getRootIndex() {
        return ModelUtil.resolveDefaultInteger(((MetaschemaAssembly)this.getAnnotation()).rootIndex());
    }
}

