/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.constraint.AssemblyConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFieldValue;
import gov.nist.secauto.metaschema.databind.model.annotations.Ignore;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaField;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.impl.AbstractBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.impl.ConstraintSupport;
import gov.nist.secauto.metaschema.databind.model.impl.FlagContainerSupport;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public final class DefinitionField
extends AbstractBoundDefinitionModelComplex<MetaschemaField>
implements IBoundDefinitionModelFieldComplex {
    @NonNull
    private final FieldValue fieldValue;
    @Nullable
    private IBoundInstanceFlag jsonValueKeyFlagInstance;
    @NonNull
    private final Lazy<FlagContainerSupport> flagContainer;
    @NonNull
    private final Lazy<IValueConstrained> constraints;
    @NonNull
    private final Lazy<Map<String, IBoundProperty<?>>> jsonProperties;
    @NonNull
    private final Lazy<Map<IAttributable.Key, Set<String>>> properties;

    @Nullable
    private static Field getFieldValueField(Class<?> clazz) {
        Class<?> superClass;
        Field[] fields = clazz.getDeclaredFields();
        Field retval = null;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(BoundFieldValue.class) || field.isAnnotationPresent(Ignore.class)) continue;
            retval = field;
        }
        if (retval == null && (superClass = clazz.getSuperclass()) != null) {
            retval = DefinitionField.getFieldValueField(superClass);
        }
        return retval;
    }

    @NonNull
    public static DefinitionField newInstance(@NonNull Class<? extends IBoundObject> clazz, @NonNull MetaschemaField annotation, @NonNull IBoundModule module, @NonNull IBindingContext bindingContext) {
        return new DefinitionField(clazz, annotation, module, bindingContext);
    }

    private DefinitionField(@NonNull Class<? extends IBoundObject> clazz, @NonNull MetaschemaField annotation, @NonNull IBoundModule module, @NonNull IBindingContext bindingContext) {
        super(clazz, annotation, module, bindingContext);
        Field field = DefinitionField.getFieldValueField(this.getBoundClass());
        if (field == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing the '%s' annotation on one of its fields.", clazz.getName(), BoundFieldValue.class.getName()));
        }
        this.fieldValue = new FieldValue(field, BoundFieldValue.class, bindingContext);
        this.flagContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> new FlagContainerSupport(this, this::handleFlagInstance)));
        this.constraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            AssemblyConstraintSet retval = new AssemblyConstraintSet();
            ValueConstraints valueAnnotation = ((MetaschemaField)this.getAnnotation()).valueConstraints();
            ConstraintSupport.parse(valueAnnotation, module.getSource(), (IValueConstrained)retval);
            return retval;
        }));
        this.jsonProperties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            IBoundInstanceFlag jsonValueKey = this.getJsonValueKeyFlagInstance();
            Predicate<IBoundInstanceFlag> flagFilter = jsonValueKey == null ? null : flag -> !flag.equals(jsonValueKey);
            return this.getJsonProperties(flagFilter);
        }));
        this.properties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(annotation.properties()).map(ModelUtil::toPropertyEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new)))))));
    }

    protected void handleFlagInstance(@NonNull IBoundInstanceFlag instance) {
        if (instance.isJsonValueKey()) {
            this.jsonValueKeyFlagInstance = instance;
        }
    }

    @Override
    @NonNull
    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    public IBoundInstanceFlag getJsonValueKeyFlagInstance() {
        this.getFlagContainer();
        return this.jsonValueKeyFlagInstance;
    }

    @Override
    protected void deepCopyItemInternal(IBoundObject fromObject, IBoundObject toObject) throws BindingException {
        super.deepCopyItemInternal(fromObject, toObject);
        this.getFieldValue().deepCopy(fromObject, toObject);
    }

    @NonNull
    public FlagContainerSupport getFlagContainer() {
        return (FlagContainerSupport)this.flagContainer.get();
    }

    @NonNull
    public IValueConstrained getConstraintSupport() {
        return (IValueConstrained)ObjectUtils.notNull((Object)((IValueConstrained)this.constraints.get()));
    }

    @Override
    public Map<String, IBoundProperty<?>> getJsonProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.jsonProperties.get()));
    }

    @Nullable
    public String getFormalName() {
        return ModelUtil.resolveNoneOrValue(((MetaschemaField)this.getAnnotation()).formalName());
    }

    @Nullable
    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(((MetaschemaField)this.getAnnotation()).description());
    }

    @NonNull
    public String getName() {
        return ((MetaschemaField)this.getAnnotation()).name();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.properties.get()));
    }

    @Nullable
    public Integer getIndex() {
        return ModelUtil.resolveDefaultInteger(((MetaschemaField)this.getAnnotation()).index());
    }

    @Nullable
    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(((MetaschemaField)this.getAnnotation()).description());
    }

    protected class FieldValue
    implements IBoundFieldValue {
        @NonNull
        private final Field javaField;
        @NonNull
        private final BoundFieldValue annotation;
        @NonNull
        private final IDataTypeAdapter<?> javaTypeAdapter;
        @Nullable
        private final Object defaultValue;

        protected FieldValue(@NonNull Field javaField, @NonNull Class<BoundFieldValue> annotationClass, IBindingContext bindingContext) {
            this.javaField = javaField;
            this.annotation = ModelUtil.getAnnotation(javaField, annotationClass);
            this.javaTypeAdapter = ModelUtil.getDataTypeAdapter(this.annotation.typeAdapter(), bindingContext);
            this.defaultValue = ModelUtil.resolveDefaultValue(this.annotation.defaultValue(), this.javaTypeAdapter);
        }

        @Override
        @NonNull
        public Field getField() {
            return this.javaField;
        }

        @NonNull
        public BoundFieldValue getAnnotation() {
            return this.annotation;
        }

        @Override
        public IBoundDefinitionModelFieldComplex getParentFieldDefinition() {
            return DefinitionField.this;
        }

        @Override
        public String getJsonValueKeyName() {
            String name = ModelUtil.resolveNoneOrValue(this.getAnnotation().valueKeyName());
            return name == null ? this.getJavaTypeAdapter().getDefaultJsonValueKey() : name;
        }

        @Override
        public String getJsonValueKeyFlagName() {
            return ModelUtil.resolveNoneOrValue(this.getAnnotation().valueKeyName());
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public IDataTypeAdapter<?> getJavaTypeAdapter() {
            return this.javaTypeAdapter;
        }

        @Override
        public Object getEffectiveDefaultValue() {
            return this.getDefaultValue();
        }

        public String getJsonName() {
            return DefinitionField.this.getEffectiveJsonValueKeyName();
        }
    }
}

