/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IContainerFlagSupport;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Ignore;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;

public class FlagContainerSupport
implements IContainerFlagSupport<IBoundInstanceFlag> {
    @NonNull
    private final Map<QName, IBoundInstanceFlag> flagInstances;
    @Nullable
    private IBoundInstanceFlag jsonKeyFlag;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public FlagContainerSupport(@NonNull IBoundDefinitionModelComplex definition, @Nullable Consumer<IBoundInstanceFlag> peeker) {
        Class clazz = definition.getBoundClass();
        Stream instances = FlagContainerSupport.getFlagInstanceFields(clazz).stream().flatMap(field -> {
            Stream<Object> stream = field.isAnnotationPresent(BoundFlag.class) ? Stream.of(IBoundInstanceFlag.newInstance(field, definition)) : Stream.empty();
            return stream;
        });
        Consumer<IBoundInstanceFlag> intermediate = this::handleFlagInstance;
        if (peeker != null) {
            intermediate = intermediate.andThen(peeker);
        }
        this.flagInstances = CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)instances.peek(intermediate).collect(Collectors.toMap(IFlagInstance::getXmlQName, Function.identity(), (v1, v2) -> v2, LinkedHashMap::new)))));
    }

    @NonNull
    protected static Collection<Field> getFlagInstanceFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        LinkedList<Field> retval = new LinkedList<Field>();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            retval.addAll(FlagContainerSupport.getFlagInstanceFields(superClass));
        }
        for (Field field : fields) {
            if (!field.isAnnotationPresent(BoundFlag.class) || field.isAnnotationPresent(Ignore.class)) continue;
            retval.add(field);
        }
        return (Collection)ObjectUtils.notNull(Collections.unmodifiableCollection(retval));
    }

    protected void handleFlagInstance(IBoundInstanceFlag instance) {
        if (instance.isJsonKey()) {
            this.jsonKeyFlag = instance;
        }
    }

    @NonNull
    public Map<QName, IBoundInstanceFlag> getFlagInstanceMap() {
        return this.flagInstances;
    }

    public IBoundInstanceFlag getJsonKeyFlagInstance() {
        return this.jsonKeyFlag;
    }
}

