/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.AbstractInlineFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.ValueConstraintSet;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.JsonFieldValueKeyFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.JsonKey;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.impl.ConstraintSupport;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public class InstanceFlagInline
extends AbstractInlineFlagDefinition<IBoundDefinitionModel<IBoundObject>, IBoundDefinitionFlag, IBoundInstanceFlag>
implements IBoundInstanceFlag {
    @NonNull
    private final Field javaField;
    @NonNull
    private final BoundFlag annotation;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    @NonNull
    private final Lazy<IValueConstrained> constraints;
    @NonNull
    private final Lazy<Map<IAttributable.Key, Set<String>>> properties;

    public InstanceFlagInline(@NonNull Field javaField, @NonNull IBoundDefinitionModel<IBoundObject> parent) {
        super(parent);
        this.javaField = javaField;
        this.annotation = ModelUtil.getAnnotation(javaField, BoundFlag.class);
        Class adapterClass = (Class)ObjectUtils.notNull(this.getAnnotation().typeAdapter());
        this.javaTypeAdapter = ModelUtil.getDataTypeAdapter(adapterClass, parent.getBindingContext());
        this.defaultValue = ModelUtil.resolveDefaultValue(this.getAnnotation().defaultValue(), this.javaTypeAdapter);
        IBoundModule module = parent.getContainingModule();
        this.constraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> this.lambda$new$0((IModule)module)));
        this.properties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(this.annotation.properties()).map(ModelUtil::toPropertyEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new)))))));
    }

    @Override
    @NonNull
    public Field getField() {
        return this.javaField;
    }

    @NonNull
    private BoundFlag getAnnotation() {
        return this.annotation;
    }

    @Override
    public IBoundModule getContainingModule() {
        return ((IBoundDefinitionModel)this.getContainingDefinition()).getContainingModule();
    }

    @NonNull
    public IValueConstrained getConstraintSupport() {
        return (IValueConstrained)this.constraints.get();
    }

    public boolean isRequired() {
        return this.getAnnotation().required();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isJsonKey() {
        return this.getField().isAnnotationPresent(JsonKey.class);
    }

    @Override
    public boolean isJsonValueKey() {
        return this.getField().isAnnotationPresent(JsonFieldValueKeyFlag.class);
    }

    @Override
    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    @Nullable
    public String getFormalName() {
        return ModelUtil.resolveNoneOrValue(this.getAnnotation().formalName());
    }

    @Nullable
    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getAnnotation().description());
    }

    public String getName() {
        return (String)ObjectUtils.notNull((Object)Optional.ofNullable(ModelUtil.resolveNoneOrValue(this.getAnnotation().name())).orElse(this.getField().getName()));
    }

    public Integer getUseIndex() {
        return this.getAnnotation().useIndex();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.properties.get()));
    }

    @Nullable
    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getAnnotation().remarks());
    }

    private /* synthetic */ IValueConstrained lambda$new$0(IModule module) {
        ValueConstraintSet retval = new ValueConstraintSet();
        ValueConstraints valueAnnotation = this.getAnnotation().valueConstraints();
        ConstraintSupport.parse(valueAnnotation, module.getSource(), (IValueConstrained)retval);
        return retval;
    }
}

