/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.AbstractAssemblyInstance;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IContainerModel;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public final class InstanceModelAssemblyComplex
extends AbstractAssemblyInstance<IBoundDefinitionModelAssembly, IBoundDefinitionModelAssembly, IBoundInstanceModelAssembly, IBoundDefinitionModelAssembly>
implements IBoundInstanceModelAssembly,
IFeatureInstanceModelGroupAs<IBoundObject> {
    @NonNull
    private final Field javaField;
    @NonNull
    private final BoundAssembly annotation;
    @NonNull
    private final Lazy<IModelInstanceCollectionInfo<IBoundObject>> collectionInfo;
    @NonNull
    private final IBoundDefinitionModelAssembly definition;
    @NonNull
    private final IGroupAs groupAs;
    @NonNull
    private final Lazy<Map<String, IBoundProperty<?>>> jsonProperties;
    @NonNull
    private final Lazy<Map<IAttributable.Key, Set<String>>> properties;

    @NonNull
    public static InstanceModelAssemblyComplex newInstance(@NonNull Field javaField, @NonNull IBoundDefinitionModelAssembly definition, @NonNull IBoundDefinitionModelAssembly containingDefinition) {
        BoundAssembly annotation = ModelUtil.getAnnotation(javaField, BoundAssembly.class);
        IGroupAs groupAs = ModelUtil.resolveDefaultGroupAs(annotation.groupAs(), (IModule)containingDefinition.getContainingModule());
        if (annotation.maxOccurs() == -1 || annotation.maxOccurs() > 1) {
            if (IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is missing the '%s' annotation.", javaField.getName(), containingDefinition.getBoundClass().getName(), GroupAs.class.getName()));
            }
        } else if (!IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
            throw new IllegalStateException(String.format("Field '%s' on class '%s' has the '%s' annotation, but maxOccurs=1. A groupAs must not be specfied.", javaField.getName(), containingDefinition.getBoundClass().getName(), GroupAs.class.getName()));
        }
        return new InstanceModelAssemblyComplex(javaField, annotation, groupAs, definition, containingDefinition);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    private InstanceModelAssemblyComplex(@NonNull Field javaField, @NonNull BoundAssembly annotation, @NonNull IGroupAs groupAs, @NonNull IBoundDefinitionModelAssembly definition, @NonNull IBoundDefinitionModelAssembly containingDefinition) {
        super((IContainerModel)containingDefinition);
        this.javaField = javaField;
        this.annotation = annotation;
        this.groupAs = groupAs;
        this.collectionInfo = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> IModelInstanceCollectionInfo.of(this)));
        this.definition = definition;
        this.jsonProperties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            IBoundInstanceFlag jsonKey = this.getEffectiveJsonKey();
            Predicate<IBoundInstanceFlag> flagFilter = jsonKey == null ? null : flag -> !jsonKey.equals(flag);
            return this.getDefinition().getJsonProperties(flagFilter);
        }));
        this.properties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(annotation.properties()).map(ModelUtil::toPropertyEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new)))))));
    }

    @Override
    public Field getField() {
        return this.javaField;
    }

    @NonNull
    public BoundAssembly getAnnotation() {
        return this.annotation;
    }

    @Override
    public IModelInstanceCollectionInfo<IBoundObject> getCollectionInfo() {
        return (IModelInstanceCollectionInfo)this.collectionInfo.get();
    }

    @Override
    public Map<String, IBoundProperty<?>> getJsonProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.jsonProperties.get()));
    }

    @Override
    public IBoundDefinitionModelAssembly getDefinition() {
        return this.definition;
    }

    @Override
    public IBoundModule getContainingModule() {
        return ((IBoundDefinitionModelAssembly)this.getContainingDefinition()).getContainingModule();
    }

    @Override
    public IGroupAs getGroupAs() {
        return this.groupAs;
    }

    public String getFormalName() {
        return ModelUtil.resolveNoneOrValue(this.getAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getAnnotation().description());
    }

    public String getUseName() {
        return ModelUtil.resolveNoneOrValue(this.getAnnotation().useName());
    }

    public Integer getUseIndex() {
        int value = this.getAnnotation().useIndex();
        return value == Integer.MIN_VALUE ? null : Integer.valueOf(value);
    }

    public int getMinOccurs() {
        return this.getAnnotation().minOccurs();
    }

    public int getMaxOccurs() {
        return this.getAnnotation().maxOccurs();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.properties.get()));
    }

    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getAnnotation().remarks());
    }
}

