/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.AbstractChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IContainerModelSupport;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedModelInstance;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.CustomCollectors;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedNamed;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundGroupedField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureBoundContainerModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public final class InstanceModelChoiceGroup
extends AbstractChoiceGroupInstance<IBoundDefinitionModelAssembly, IBoundInstanceModelGroupedNamed, IBoundInstanceModelGroupedField, IBoundInstanceModelGroupedAssembly>
implements IBoundInstanceModelChoiceGroup,
IFeatureBoundContainerModelChoiceGroup,
IFeatureInstanceModelGroupAs<IBoundObject> {
    @NonNull
    private final Field javaField;
    @NonNull
    private final BoundChoiceGroup annotation;
    @NonNull
    private final Lazy<IModelInstanceCollectionInfo<IBoundObject>> collectionInfo;
    @NonNull
    private final IGroupAs groupAs;
    @NonNull
    private final Lazy<ChoiceGroupModelContainerSupport> modelContainer;
    @NonNull
    private final Lazy<Map<Class<?>, IBoundInstanceModelGroupedNamed>> classToInstanceMap;
    @NonNull
    private final Lazy<Map<QName, IBoundInstanceModelGroupedNamed>> qnameToInstanceMap;
    @NonNull
    private final Lazy<Map<String, IBoundInstanceModelGroupedNamed>> discriminatorToInstanceMap;

    @NonNull
    public static InstanceModelChoiceGroup newInstance(@NonNull Field javaField, @NonNull IBoundDefinitionModelAssembly parent) {
        BoundChoiceGroup annotation = ModelUtil.getAnnotation(javaField, BoundChoiceGroup.class);
        IGroupAs groupAs = ModelUtil.resolveDefaultGroupAs(annotation.groupAs(), (IModule)parent.getContainingModule());
        if (annotation.maxOccurs() == -1 || annotation.maxOccurs() > 1) {
            if (IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is missing the '%s' annotation.", javaField.getName(), parent.getBoundClass().getName(), GroupAs.class.getName()));
            }
        } else if (!IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
            throw new IllegalStateException(String.format("Field '%s' on class '%s' has the '%s' annotation, but maxOccurs=1. A groupAs must not be specfied.", javaField.getName(), parent.getBoundClass().getName(), GroupAs.class.getName()));
        }
        return new InstanceModelChoiceGroup(javaField, annotation, groupAs, parent);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    private InstanceModelChoiceGroup(@NonNull Field javaField, @NonNull BoundChoiceGroup annotation, @NonNull IGroupAs groupAs, @NonNull IBoundDefinitionModelAssembly parent) {
        super((IAssemblyDefinition)parent);
        this.javaField = javaField;
        this.annotation = annotation;
        this.groupAs = groupAs;
        this.collectionInfo = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> IModelInstanceCollectionInfo.of(this)));
        this.modelContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> new ChoiceGroupModelContainerSupport(this.annotation.assemblies(), this.annotation.fields(), this)));
        this.classToInstanceMap = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> Collections.unmodifiableMap(this.getNamedModelInstances().stream().map(instance -> instance).collect(Collectors.toMap(item -> item.getDefinition().getBoundClass(), CustomCollectors.identity())))));
        this.qnameToInstanceMap = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> Collections.unmodifiableMap(this.getNamedModelInstances().stream().collect(Collectors.toMap(INamedModelInstance::getXmlQName, CustomCollectors.identity())))));
        this.discriminatorToInstanceMap = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> Collections.unmodifiableMap(this.getNamedModelInstances().stream().collect(Collectors.toMap(INamedModelInstanceGrouped::getEffectiveDisciminatorValue, CustomCollectors.identity())))));
    }

    @Override
    public Field getField() {
        return this.javaField;
    }

    @NonNull
    public BoundChoiceGroup getAnnotation() {
        return this.annotation;
    }

    @Override
    public IModelInstanceCollectionInfo<IBoundObject> getCollectionInfo() {
        return (IModelInstanceCollectionInfo)this.collectionInfo.get();
    }

    @NonNull
    protected Map<QName, IBoundInstanceModelGroupedNamed> getQNameToInstanceMap() {
        return (Map)this.qnameToInstanceMap.get();
    }

    @NonNull
    protected Map<Class<?>, IBoundInstanceModelGroupedNamed> getClassToInstanceMap() {
        return (Map)this.classToInstanceMap.get();
    }

    @NonNull
    protected Map<String, IBoundInstanceModelGroupedNamed> getDiscriminatorToInstanceMap() {
        return (Map)this.discriminatorToInstanceMap.get();
    }

    @Override
    @Nullable
    public IBoundInstanceModelGroupedNamed getGroupedModelInstance(@NonNull Class<?> clazz) {
        return this.getClassToInstanceMap().get(clazz);
    }

    @Override
    @Nullable
    public IBoundInstanceModelGroupedNamed getGroupedModelInstance(@NonNull QName name) {
        return this.getQNameToInstanceMap().get(name);
    }

    @Override
    public IBoundInstanceModelGroupedNamed getGroupedModelInstance(String discriminator) {
        return this.getDiscriminatorToInstanceMap().get(discriminator);
    }

    @Override
    public IGroupAs getGroupAs() {
        return this.groupAs;
    }

    public ChoiceGroupModelContainerSupport getModelContainer() {
        return (ChoiceGroupModelContainerSupport)this.modelContainer.get();
    }

    @Override
    public IBoundDefinitionModelAssembly getOwningDefinition() {
        return (IBoundDefinitionModelAssembly)this.getParentContainer();
    }

    @Override
    public IBoundModule getContainingModule() {
        return this.getOwningDefinition().getContainingModule();
    }

    public int getMinOccurs() {
        return this.getAnnotation().minOccurs();
    }

    public int getMaxOccurs() {
        return this.getAnnotation().maxOccurs();
    }

    public String getJsonDiscriminatorProperty() {
        return this.getAnnotation().discriminator();
    }

    public String getJsonKeyFlagInstanceName() {
        return this.getAnnotation().jsonKey();
    }

    @Override
    public IBoundInstanceFlag getItemJsonKey(Object item) {
        String jsonKeyFlagName = this.getJsonKeyFlagInstanceName();
        IBoundInstanceFlag retval = null;
        if (jsonKeyFlagName != null) {
            Class<?> clazz = item.getClass();
            IBoundInstanceModelGroupedNamed itemInstance = this.getClassToInstanceMap().get(clazz);
            retval = (IBoundInstanceFlag)itemInstance.getDefinition().getFlagInstanceByName(new QName(itemInstance.getXmlNamespace(), jsonKeyFlagName));
        }
        return retval;
    }

    private static class ChoiceGroupModelContainerSupport
    implements IContainerModelSupport<IBoundInstanceModelGroupedNamed, IBoundInstanceModelGroupedNamed, IBoundInstanceModelGroupedField, IBoundInstanceModelGroupedAssembly> {
        @NonNull
        private final Map<QName, IBoundInstanceModelGroupedNamed> namedModelInstances;
        @NonNull
        private final Map<QName, IBoundInstanceModelGroupedField> fieldInstances;
        @NonNull
        private final Map<QName, IBoundInstanceModelGroupedAssembly> assemblyInstances;

        public ChoiceGroupModelContainerSupport(@NonNull BoundGroupedAssembly[] assemblies, @NonNull BoundGroupedField[] fields, @NonNull IBoundInstanceModelChoiceGroup container) {
            this.assemblyInstances = CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(assemblies).map(instance -> {
                assert (instance != null);
                return IBoundInstanceModelGroupedAssembly.newInstance(instance, container);
            }).collect(Collectors.toMap(INamedModelInstance::getXmlQName, Function.identity(), CustomCollectors.useLastMapper(), LinkedHashMap::new)))));
            this.fieldInstances = CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(fields).map(instance -> {
                assert (instance != null);
                return IBoundInstanceModelGroupedField.newInstance(instance, container);
            }).collect(Collectors.toMap(INamedModelInstance::getXmlQName, Function.identity(), CustomCollectors.useLastMapper(), LinkedHashMap::new)))));
            this.namedModelInstances = CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Stream.concat(this.assemblyInstances.entrySet().stream(), this.fieldInstances.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, CustomCollectors.useLastMapper(), LinkedHashMap::new)))));
        }

        public Collection<IBoundInstanceModelGroupedNamed> getModelInstances() {
            return this.namedModelInstances.values();
        }

        public Map<QName, IBoundInstanceModelGroupedNamed> getNamedModelInstanceMap() {
            return this.namedModelInstances;
        }

        public Map<QName, IBoundInstanceModelGroupedField> getFieldInstanceMap() {
            return this.fieldInstances;
        }

        public Map<QName, IBoundInstanceModelGroupedAssembly> getAssemblyInstanceMap() {
            return this.assemblyInstances;
        }
    }
}

