/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.AbstractFieldInstance;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IContainerModel;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldComplex;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.IBoundProperty;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.impl.DefinitionField;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public final class InstanceModelFieldComplex
extends AbstractFieldInstance<IBoundDefinitionModelAssembly, IBoundDefinitionModelFieldComplex, IBoundInstanceModelFieldComplex, IBoundDefinitionModelAssembly>
implements IBoundInstanceModelFieldComplex,
IFeatureInstanceModelGroupAs<IBoundObject> {
    @NonNull
    private final Field javaField;
    @NonNull
    private final BoundField annotation;
    @NonNull
    private final Lazy<IModelInstanceCollectionInfo<IBoundObject>> collectionInfo;
    @NonNull
    private final IGroupAs groupAs;
    @NonNull
    private final DefinitionField definition;
    @NonNull
    private final Lazy<Object> defaultValue;
    @NonNull
    private final Lazy<Map<String, IBoundProperty<?>>> jsonProperties;
    @NonNull
    private final Lazy<Map<IAttributable.Key, Set<String>>> properties;

    @NonNull
    public static InstanceModelFieldComplex newInstance(@NonNull Field javaField, @NonNull DefinitionField definition, @NonNull IBoundDefinitionModelAssembly parent) {
        BoundField annotation = ModelUtil.getAnnotation(javaField, BoundField.class);
        if (!annotation.inXmlWrapped()) {
            if (definition.hasChildren()) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is requested to be unwrapped, but it has flags preventing this.", javaField.getName(), parent.getBoundClass().getName()));
            }
            if (!definition.getJavaTypeAdapter().isUnrappedValueAllowedInXml()) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is requested to be unwrapped, but its data type '%s' does not allow this.", javaField.getName(), parent.getBoundClass().getName(), definition.getJavaTypeAdapter().getPreferredName()));
            }
        }
        IGroupAs groupAs = ModelUtil.resolveDefaultGroupAs(annotation.groupAs(), (IModule)parent.getContainingModule());
        if (annotation.maxOccurs() == -1 || annotation.maxOccurs() > 1) {
            if (IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is missing the '%s' annotation.", javaField.getName(), javaField.getDeclaringClass().getName(), GroupAs.class.getName()));
            }
        } else if (!IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
            throw new IllegalStateException(String.format("Field '%s' on class '%s' has the '%s' annotation, but maxOccurs=1. A groupAs must not be specfied.", javaField.getName(), javaField.getDeclaringClass().getName(), GroupAs.class.getName()));
        }
        return new InstanceModelFieldComplex(javaField, annotation, groupAs, definition, parent);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    private InstanceModelFieldComplex(@NonNull Field javaField, @NonNull BoundField annotation, @NonNull IGroupAs groupAs, @NonNull DefinitionField definition, @NonNull IBoundDefinitionModelAssembly parent) {
        super((IContainerModel)parent);
        this.javaField = javaField;
        this.annotation = annotation;
        this.collectionInfo = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> IModelInstanceCollectionInfo.of(this)));
        this.groupAs = groupAs;
        this.definition = definition;
        this.defaultValue = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            DefinitionField.FieldValue fieldValue;
            Object fieldValueDefault;
            IBoundObject retval = null;
            if (this.getMaxOccurs() == 1 && (fieldValueDefault = (fieldValue = definition.getFieldValue()).getDefaultValue()) != null) {
                retval = this.newInstance(null);
                fieldValue.setValue((Object)retval, fieldValueDefault);
                for (IBoundInstanceFlag flag : definition.getFlagInstances()) {
                    Object flagDefault = flag.getResolvedDefaultValue();
                    if (flagDefault == null) continue;
                    flag.setValue(retval, flagDefault);
                }
            }
            return retval;
        }));
        this.jsonProperties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            Predicate<IBoundInstanceFlag> flagFilter = null;
            IBoundInstanceFlag jsonKey = this.getEffectiveJsonKey();
            if (jsonKey != null) {
                flagFilter = flag -> !jsonKey.equals(flag);
            }
            return this.getDefinition().getJsonProperties(flagFilter);
        }));
        this.properties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(annotation.properties()).map(ModelUtil::toPropertyEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new)))))));
    }

    @Override
    public Field getField() {
        return this.javaField;
    }

    @NonNull
    public BoundField getAnnotation() {
        return this.annotation;
    }

    @Override
    public IModelInstanceCollectionInfo<IBoundObject> getCollectionInfo() {
        return (IModelInstanceCollectionInfo)this.collectionInfo.get();
    }

    @Override
    public DefinitionField getDefinition() {
        return this.definition;
    }

    @Override
    public IBoundModule getContainingModule() {
        return ((IBoundDefinitionModelAssembly)this.getContainingDefinition()).getContainingModule();
    }

    public Object getDefaultValue() {
        return this.defaultValue.get();
    }

    @Override
    public Map<String, IBoundProperty<?>> getJsonProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.jsonProperties.get()));
    }

    @Override
    public IGroupAs getGroupAs() {
        return this.groupAs;
    }

    public String getFormalName() {
        return ModelUtil.resolveNoneOrValue(this.getAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getAnnotation().description());
    }

    public String getUseName() {
        return ModelUtil.resolveNoneOrValue(this.getAnnotation().useName());
    }

    public Integer getUseIndex() {
        int value = this.getAnnotation().useIndex();
        return value == Integer.MIN_VALUE ? null : Integer.valueOf(value);
    }

    public boolean isInXmlWrapped() {
        return this.getAnnotation().inXmlWrapped();
    }

    public int getMinOccurs() {
        return this.getAnnotation().minOccurs();
    }

    public int getMaxOccurs() {
        return this.getAnnotation().maxOccurs();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.properties.get()));
    }

    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getAnnotation().remarks());
    }
}

