/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.AbstractInlineFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IContainerModel;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.ValueConstraintSet;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelField;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelFieldScalar;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.impl.ConstraintSupport;
import gov.nist.secauto.metaschema.databind.model.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public final class InstanceModelFieldScalar
extends AbstractInlineFieldDefinition<IBoundDefinitionModelAssembly, IBoundDefinitionModelField<Object>, IBoundInstanceModelFieldScalar, IBoundDefinitionModelAssembly, IBoundInstanceFlag>
implements IBoundInstanceModelFieldScalar,
IFeatureInstanceModelGroupAs<Object> {
    @NonNull
    private final Field javaField;
    @NonNull
    private final BoundField annotation;
    @NonNull
    private final Lazy<IModelInstanceCollectionInfo<Object>> collectionInfo;
    @NonNull
    private final IGroupAs groupAs;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    @NonNull
    private final Lazy<IValueConstrained> constraints;
    @NonNull
    private final Lazy<Map<IAttributable.Key, Set<String>>> properties;

    @NonNull
    public static InstanceModelFieldScalar newInstance(@NonNull Field javaField, @NonNull IBoundDefinitionModelAssembly parent) {
        BoundField annotation = ModelUtil.getAnnotation(javaField, BoundField.class);
        IGroupAs groupAs = ModelUtil.resolveDefaultGroupAs(annotation.groupAs(), (IModule)parent.getContainingModule());
        if (annotation.maxOccurs() == -1 || annotation.maxOccurs() > 1) {
            if (IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
                throw new IllegalStateException(String.format("Field '%s' on class '%s' is missing the '%s' annotation.", javaField.getName(), javaField.getDeclaringClass().getName(), GroupAs.class.getName()));
            }
        } else if (!IGroupAs.SINGLETON_GROUP_AS.equals(groupAs)) {
            throw new IllegalStateException(String.format("Field '%s' on class '%s' has the '%s' annotation, but maxOccurs=1. A groupAs must not be specfied.", javaField.getName(), javaField.getDeclaringClass().getName(), GroupAs.class.getName()));
        }
        return new InstanceModelFieldScalar(javaField, annotation, groupAs, parent);
    }

    private InstanceModelFieldScalar(@NonNull Field javaField, @NonNull BoundField annotation, @NonNull IGroupAs groupAs, @NonNull IBoundDefinitionModelAssembly parent) {
        super((IContainerModel)parent);
        this.javaField = javaField;
        this.annotation = annotation;
        this.collectionInfo = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> IModelInstanceCollectionInfo.of(this)));
        this.groupAs = groupAs;
        this.javaTypeAdapter = ModelUtil.getDataTypeAdapter(annotation.typeAdapter(), parent.getBindingContext());
        this.defaultValue = ModelUtil.resolveDefaultValue(annotation.defaultValue(), this.javaTypeAdapter);
        IBoundModule module = this.getContainingModule();
        this.constraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> InstanceModelFieldScalar.lambda$new$1(annotation, (IModule)module)));
        this.properties = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull((Object)Arrays.stream(annotation.properties()).map(ModelUtil::toPropertyEntry).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2, LinkedHashMap::new)))))));
    }

    @Override
    public IBindingContext getBindingContext() {
        return ((IBoundDefinitionModelAssembly)this.getContainingDefinition()).getBindingContext();
    }

    @Override
    public IBoundModule getContainingModule() {
        return ((IBoundDefinitionModelAssembly)this.getContainingDefinition()).getContainingModule();
    }

    @Override
    public Field getField() {
        return this.javaField;
    }

    @NonNull
    public BoundField getAnnotation() {
        return this.annotation;
    }

    @Override
    public IModelInstanceCollectionInfo<Object> getCollectionInfo() {
        return (IModelInstanceCollectionInfo)this.collectionInfo.get();
    }

    @NonNull
    public IValueConstrained getConstraintSupport() {
        return (IValueConstrained)this.constraints.get();
    }

    @Override
    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public IGroupAs getGroupAs() {
        return this.groupAs;
    }

    public String getFormalName() {
        return ModelUtil.resolveNoneOrValue(this.getAnnotation().formalName());
    }

    public MarkupLine getDescription() {
        return ModelUtil.resolveToMarkupLine(this.getAnnotation().description());
    }

    public Integer getUseIndex() {
        int value = this.getAnnotation().useIndex();
        return value == Integer.MIN_VALUE ? null : Integer.valueOf(value);
    }

    public boolean isInXmlWrapped() {
        return this.getAnnotation().inXmlWrapped();
    }

    public int getMinOccurs() {
        return this.getAnnotation().minOccurs();
    }

    public int getMaxOccurs() {
        return this.getAnnotation().maxOccurs();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return (Map)ObjectUtils.notNull((Object)((Map)this.properties.get()));
    }

    public MarkupMultiline getRemarks() {
        return ModelUtil.resolveToMarkupMultiline(this.getAnnotation().remarks());
    }

    @Override
    public String getName() {
        return (String)ObjectUtils.notNull((Object)Optional.ofNullable(ModelUtil.resolveNoneOrValue(this.getAnnotation().useName())).orElse(this.getField().getName()));
    }

    private static /* synthetic */ IValueConstrained lambda$new$1(BoundField annotation, IModule module) {
        ValueConstraintSet retval = new ValueConstraintSet();
        ValueConstraints valueAnnotation = annotation.valueConstraints();
        ConstraintSupport.parse(valueAnnotation, module.getSource(), (IValueConstrained)retval);
        return retval;
    }
}

