/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.info;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelNamed;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceReadHandler;

public abstract class AbstractModelInstanceReadHandler<ITEM>
implements IModelInstanceReadHandler<ITEM> {
    @NonNull
    private final IBoundInstanceModel<ITEM> instance;
    @NonNull
    private final IBoundObject parentObject;

    protected AbstractModelInstanceReadHandler(@NonNull IBoundInstanceModel<ITEM> instance, @NonNull IBoundObject parentObject) {
        this.instance = instance;
        this.parentObject = parentObject;
    }

    @NonNull
    public IBoundInstanceModel<ITEM> getInstance() {
        return this.instance;
    }

    @NonNull
    public IModelInstanceCollectionInfo<ITEM> getCollectionInfo() {
        return this.getInstance().getCollectionInfo();
    }

    @NonNull
    public IBoundObject getParentObject() {
        return this.parentObject;
    }

    @Override
    public String getJsonKeyFlagName() {
        IBoundInstanceFlag jsonKey;
        IBoundInstanceModel<ITEM> instance = this.getInstance();
        String retval = null;
        if (instance instanceof IBoundInstanceModelNamed && (jsonKey = ((IBoundInstanceModelNamed)instance).getEffectiveJsonKey()) != null) {
            retval = jsonKey.getEffectiveName();
        }
        return retval;
    }
}

