/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.info;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceWriteHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class AbstractModelInstanceWriteHandler<ITEM>
implements IModelInstanceWriteHandler<ITEM> {
    @NonNull
    private final IBoundInstanceModel<ITEM> instance;

    public AbstractModelInstanceWriteHandler(@NonNull IBoundInstanceModel<ITEM> instance) {
        this.instance = instance;
    }

    public IBoundInstanceModel<ITEM> getInstance() {
        return this.instance;
    }

    @NonNull
    public IModelInstanceCollectionInfo<ITEM> getCollectionInfo() {
        return this.instance.getCollectionInfo();
    }

    @Override
    public void writeList(List<ITEM> items) throws IOException {
        this.writeCollection(items);
    }

    @Override
    public void writeMap(Map<String, ITEM> items) throws IOException {
        this.writeCollection((Collection)ObjectUtils.notNull(items.values()));
    }

    private void writeCollection(@NonNull Collection<ITEM> items) throws IOException {
        for (ITEM item : items) {
            this.writeItem(ObjectUtils.requireNonNull(item));
        }
    }
}

