/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.info;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceWriteHandler;
import gov.nist.secauto.metaschema.databind.model.info.ListCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.MapCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.SingletonCollectionInfo;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface IModelInstanceCollectionInfo<ITEM> {
    @NonNull
    public static <T> IModelInstanceCollectionInfo<T> of(@NonNull IBoundInstanceModel<T> instance) {
        AbstractModelInstanceCollectionInfo retval;
        Type type = instance.getType();
        Field field = instance.getField();
        if (instance.getMaxOccurs() == -1 || instance.getMaxOccurs() > 1) {
            JsonGroupAsBehavior jsonGroupAs = instance.getJsonGroupAsBehavior();
            if (!(type instanceof ParameterizedType)) {
                switch (jsonGroupAs) {
                    case KEYED: {
                        throw new IllegalStateException(String.format("The field '%s' on class '%s' has data type of '%s', but should have a type of '%s'.", field.getName(), field.getDeclaringClass().getName(), field.getType().getName(), Map.class.getName()));
                    }
                    case LIST: 
                    case SINGLETON_OR_LIST: {
                        throw new IllegalStateException(String.format("The field '%s' on class '%s' has data type of '%s', but should have a type of '%s'.", field.getName(), field.getDeclaringClass().getName(), field.getType().getName(), List.class.getName()));
                    }
                }
                throw new IllegalStateException(jsonGroupAs.name());
            }
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            if (JsonGroupAsBehavior.KEYED.equals((Object)jsonGroupAs)) {
                if (!Map.class.isAssignableFrom(rawType)) {
                    throw new IllegalArgumentException(String.format("The field '%s' on class '%s' has data type '%s', which is not the expected '%s' derived data type.", field.getName(), field.getDeclaringClass().getName(), field.getType().getName(), Map.class.getName()));
                }
                retval = new MapCollectionInfo<T>(instance);
            } else {
                if (!List.class.isAssignableFrom(rawType)) {
                    throw new IllegalArgumentException(String.format("The field '%s' on class '%s' has data type '%s', which is not the expected '%s' derived data type.", field.getName(), field.getDeclaringClass().getName(), field.getType().getName(), List.class.getName()));
                }
                retval = new ListCollectionInfo<T>(instance);
            }
        } else {
            if (type instanceof ParameterizedType) {
                throw new IllegalStateException(String.format("The field '%s' on class '%s' has a data parmeterized type of '%s', but the occurance is not multi-valued.", field.getName(), field.getDeclaringClass().getName(), field.getType().getName()));
            }
            retval = new SingletonCollectionInfo<T>(instance);
        }
        return retval;
    }

    @NonNull
    public IBoundInstanceModel<ITEM> getInstance();

    public int size(@Nullable Object var1);

    public boolean isEmpty(@Nullable Object var1);

    @NonNull
    public Class<? extends ITEM> getItemType();

    @NonNull
    default public Collection<? extends ITEM> getItemsFromParentInstance(@NonNull Object parentInstance) {
        Object value = this.getInstance().getValue(parentInstance);
        return this.getItemsFromValue(value);
    }

    @NonNull
    public Collection<? extends ITEM> getItemsFromValue(Object var1);

    public Object emptyValue();

    public Object deepCopyItems(@NonNull IBoundObject var1, @NonNull IBoundObject var2) throws BindingException;

    @Nullable
    public Object readItems(@NonNull IModelInstanceReadHandler<ITEM> var1) throws IOException;

    public void writeItems(@NonNull IModelInstanceWriteHandler<ITEM> var1, @NonNull Object var2) throws IOException;
}

