/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.info;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceWriteHandler;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.LinkedList;
import java.util.List;

class ListCollectionInfo<ITEM>
extends AbstractModelInstanceCollectionInfo<ITEM> {
    public ListCollectionInfo(@NonNull IBoundInstanceModel<ITEM> instance) {
        super(instance);
    }

    @Override
    public Class<? extends ITEM> getItemType() {
        ParameterizedType actualType = (ParameterizedType)this.getInstance().getType();
        return (Class)ObjectUtils.notNull((Object)((Class)actualType.getActualTypeArguments()[0]));
    }

    @Override
    public List<ITEM> getItemsFromParentInstance(Object parentInstance) {
        Object value = this.getInstance().getValue(parentInstance);
        return this.getItemsFromValue(value);
    }

    @Override
    public List<ITEM> getItemsFromValue(Object value) {
        return value == null ? CollectionUtil.emptyList() : (List)value;
    }

    @Override
    public int size(Object value) {
        return value == null ? 0 : ((List)value).size();
    }

    @Override
    public boolean isEmpty(@Nullable Object value) {
        return value == null || ((List)value).isEmpty();
    }

    @Override
    public List<ITEM> deepCopyItems(@NonNull IBoundObject fromInstance, @NonNull IBoundObject toInstance) throws BindingException {
        IBoundInstanceModel instance = this.getInstance();
        Object copy = this.emptyValue();
        for (Object item : this.getItemsFromParentInstance(fromInstance)) {
            copy.add(instance.deepCopyItem(ObjectUtils.requireNonNull(item), toInstance));
        }
        return copy;
    }

    @Override
    public List<ITEM> emptyValue() {
        return new LinkedList();
    }

    @Override
    public List<ITEM> readItems(IModelInstanceReadHandler<ITEM> handler) throws IOException {
        return handler.readList();
    }

    @Override
    public void writeItems(IModelInstanceWriteHandler<ITEM> handler, Object value) throws IOException {
        handler.writeList((List)value);
    }
}

