/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.info;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceFlag;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceWriteHandler;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

class MapCollectionInfo<ITEM>
extends AbstractModelInstanceCollectionInfo<ITEM> {
    public MapCollectionInfo(@NonNull IBoundInstanceModel<ITEM> instance) {
        super(instance);
    }

    @Override
    public Collection<ITEM> getItemsFromValue(Object value) {
        return value == null ? CollectionUtil.emptyList() : (Collection)ObjectUtils.notNull(((Map)value).values());
    }

    @Override
    public int size(Object value) {
        return value == null ? 0 : ((Map)value).size();
    }

    @Override
    public boolean isEmpty(@Nullable Object value) {
        return value == null || ((Map)value).isEmpty();
    }

    @NonNull
    public Class<?> getKeyType() {
        ParameterizedType actualType = (ParameterizedType)this.getInstance().getType();
        return (Class)actualType.getActualTypeArguments()[0];
    }

    @Override
    public Class<? extends ITEM> getItemType() {
        return this.getValueType();
    }

    @NonNull
    public Class<? extends ITEM> getValueType() {
        ParameterizedType actualType = (ParameterizedType)this.getInstance().getType();
        return (Class)actualType.getActualTypeArguments()[1];
    }

    @Override
    public Map<String, ITEM> deepCopyItems(@NonNull IBoundObject fromInstance, @NonNull IBoundObject toInstance) throws BindingException {
        IBoundInstanceModel instance = this.getInstance();
        Object copy = this.emptyValue();
        for (Object item : this.getItemsFromParentInstance(fromInstance)) {
            assert (item != null);
            IBoundInstanceFlag jsonKey = instance.getItemJsonKey(item);
            assert (jsonKey != null);
            Object itemCopy = instance.deepCopyItem(ObjectUtils.requireNonNull(item), toInstance);
            String key = ObjectUtils.requireNonNull((Object)jsonKey.getValue(itemCopy)).toString();
            copy.put(key, itemCopy);
        }
        return copy;
    }

    @Override
    public Map<String, ITEM> emptyValue() {
        return new LinkedHashMap();
    }

    @Override
    public Map<String, ITEM> readItems(IModelInstanceReadHandler<ITEM> handler) throws IOException {
        return handler.readMap();
    }

    @Override
    public void writeItems(IModelInstanceWriteHandler<ITEM> handler, Object value) throws IOException {
        handler.writeMap((Map)value);
    }
}

