/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.info;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.io.BindingException;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModel;
import gov.nist.secauto.metaschema.databind.model.info.AbstractModelInstanceCollectionInfo;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceReadHandler;
import gov.nist.secauto.metaschema.databind.model.info.IModelInstanceWriteHandler;
import java.io.IOException;
import java.util.List;

class SingletonCollectionInfo<ITEM>
extends AbstractModelInstanceCollectionInfo<ITEM> {
    public SingletonCollectionInfo(@NonNull IBoundInstanceModel<ITEM> instance) {
        super(instance);
    }

    @Override
    public List<ITEM> getItemsFromValue(Object value) {
        return value == null ? CollectionUtil.emptyList() : CollectionUtil.singletonList((Object)value);
    }

    @Override
    public int size(Object value) {
        return value == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty(@Nullable Object value) {
        return value == null;
    }

    @Override
    public Class<? extends ITEM> getItemType() {
        return this.getInstance().getItemType();
    }

    @Override
    public Object deepCopyItems(@NonNull IBoundObject fromObject, @NonNull IBoundObject toObject) throws BindingException {
        IBoundInstanceModel instance = this.getInstance();
        Object value = instance.getValue(fromObject);
        return value == null ? null : instance.deepCopyItem(ObjectUtils.requireNonNull((Object)value), toObject);
    }

    @Override
    public ITEM emptyValue() {
        return (ITEM)this.getInstance().getDefaultValue();
    }

    @Override
    public Object readItems(IModelInstanceReadHandler<ITEM> handler) throws IOException {
        ITEM value = handler.readSingleton();
        return value == null ? this.emptyValue() : value;
    }

    @Override
    public void writeItems(IModelInstanceWriteHandler<ITEM> handler, Object value) throws IOException {
        handler.writeSingleton(value);
    }
}

