/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.model.AbstractLoader;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IConstraintLoader;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractTargetedConstraints;
import gov.nist.secauto.metaschema.core.model.constraint.AssemblyConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.AssemblyTargetedConstraints;
import gov.nist.secauto.metaschema.core.model.constraint.DefaultConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.DefaultScopedContraints;
import gov.nist.secauto.metaschema.core.model.constraint.FieldTargetedConstraints;
import gov.nist.secauto.metaschema.core.model.constraint.FlagTargetedConstraints;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.constraint.IFeatureModelConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.IModelConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.IScopedContraints;
import gov.nist.secauto.metaschema.core.model.constraint.ITargetedConstraints;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.ValueConstraintSet;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.IValueConstraintsBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetapathContext;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaMetaConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaMetapath;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModuleConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ConstraintBindingSupport;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.talsmasoftware.lazy4j.Lazy;
import org.apache.xmlbeans.impl.values.XmlValueNotSupportedException;

public class BindingConstraintLoader
extends AbstractLoader<List<IConstraintSet>>
implements IConstraintLoader {
    @NonNull
    private final IBoundLoader loader;

    public BindingConstraintLoader(@NonNull IBindingContext bindingContext) {
        bindingContext.registerModule(MetaschemaModelModule.class);
        this.loader = bindingContext.newBoundLoader();
        this.loader.enableFeature(DeserializationFeature.DESERIALIZE_VALIDATE_CONSTRAINTS);
    }

    protected List<IConstraintSet> parseResource(@NonNull URI resource, @NonNull Deque<URI> visitedResources) throws IOException {
        List retval;
        Object constraintsDocument = this.loader.load(resource);
        StaticContext.Builder builder = StaticContext.builder().baseUri(resource);
        builder.useWildcardWhenNamespaceNotDefaulted(true);
        if (constraintsDocument instanceof MetaschemaModuleConstraints) {
            LinkedHashSet importedConstraints;
            MetaschemaModuleConstraints obj = (MetaschemaModuleConstraints)constraintsDocument;
            List imports = CollectionUtil.listOrEmpty(obj.getImports());
            if (imports.isEmpty()) {
                importedConstraints = CollectionUtil.emptySet();
            } else {
                try {
                    importedConstraints = new LinkedHashSet();
                    for (MetaschemaModuleConstraints.Import imported : imports) {
                        URI importedResource = imported.getHref();
                        importedResource = (URI)ObjectUtils.notNull((Object)resource.resolve(importedResource));
                        importedConstraints.addAll((Collection)this.loadInternal(importedResource, visitedResources));
                    }
                }
                catch (MetaschemaException ex) {
                    throw new IOException(ex);
                }
            }
            CollectionUtil.listOrEmpty(obj.getNamespaceBindings()).stream().forEach(binding -> builder.namespace((String)ObjectUtils.notNull((Object)binding.getPrefix()), (URI)ObjectUtils.notNull((Object)binding.getUri())));
            ISource source = ISource.externalSource((StaticContext)builder.build());
            retval = CollectionUtil.singletonList((Object)new DefaultConstraintSet(resource, this.parseScopedConstraints(obj, source), new LinkedHashSet(importedConstraints)));
        } else if (constraintsDocument instanceof MetaschemaMetaConstraints) {
            MetaschemaMetaConstraints obj = (MetaschemaMetaConstraints)constraintsDocument;
            List imports = CollectionUtil.listOrEmpty(obj.getImports());
            retval = new LinkedList();
            if (!imports.isEmpty()) {
                try {
                    for (MetaschemaMetaConstraints.Import imported : imports) {
                        URI importedResource = imported.getHref();
                        importedResource = (URI)ObjectUtils.notNull((Object)resource.resolve(importedResource));
                        retval.addAll((Collection)this.loadInternal(importedResource, visitedResources));
                    }
                }
                catch (MetaschemaException ex) {
                    throw new IOException(ex);
                }
            }
            CollectionUtil.listOrEmpty(obj.getNamespaceBindings()).stream().forEach(binding -> builder.namespace((String)ObjectUtils.notNull((Object)binding.getPrefix()), (URI)ObjectUtils.notNull((Object)binding.getUri())));
            ISource source = ISource.externalSource((StaticContext)builder.build());
            List targetedConstraints = (List)ObjectUtils.notNull(CollectionUtil.listOrEmpty(obj.getContexts()).stream().flatMap(context -> this.parseContext((MetapathContext)ObjectUtils.notNull((Object)context), null, source).getTargetedConstraints().stream()).collect(Collectors.toList()));
            retval.add((IConstraintSet)new MetaConstraintSet(targetedConstraints));
            retval = CollectionUtil.unmodifiableList(retval);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported constraint content '%s'.", resource));
        }
        return retval;
    }

    @NonNull
    protected List<IScopedContraints> parseScopedConstraints(@NonNull MetaschemaModuleConstraints obj, @NonNull ISource source) {
        LinkedList<DefaultScopedContraints> scopedConstraints = new LinkedList<DefaultScopedContraints>();
        for (MetaschemaModuleConstraints.Scope scope : CollectionUtil.listOrEmpty(obj.getScopes())) {
            assert (scope != null);
            LinkedList<Object> targetedConstraints = new LinkedList<Object>();
            try {
                for (IValueConstraintsBase constraintsObj : CollectionUtil.listOrEmpty(scope.getConstraints())) {
                    if (constraintsObj instanceof MetaschemaModuleConstraints.Scope.Assembly) {
                        targetedConstraints.add(BindingConstraintLoader.handleScopedAssembly((MetaschemaModuleConstraints.Scope.Assembly)constraintsObj, source));
                        continue;
                    }
                    if (constraintsObj instanceof MetaschemaModuleConstraints.Scope.Field) {
                        targetedConstraints.add(BindingConstraintLoader.handleScopedField((MetaschemaModuleConstraints.Scope.Field)constraintsObj, source));
                        continue;
                    }
                    if (!(constraintsObj instanceof MetaschemaModuleConstraints.Scope.Flag)) continue;
                    targetedConstraints.add(BindingConstraintLoader.handleScopedFlag((MetaschemaModuleConstraints.Scope.Flag)constraintsObj, source));
                }
            }
            catch (MetapathException | XmlValueNotSupportedException ex) {
                if (ex.getCause() instanceof MetapathException) {
                    throw new MetapathException(String.format("Unable to compile a Metapath in '%s'. %s", source.getSource(), ex.getLocalizedMessage()), ex);
                }
                throw ex;
            }
            URI namespace = (URI)ObjectUtils.requireNonNull((Object)scope.getMetaschemaNamespace());
            String shortName = (String)ObjectUtils.requireNonNull((Object)scope.getMetaschemaShortName());
            scopedConstraints.add(new DefaultScopedContraints(namespace, shortName, CollectionUtil.unmodifiableList(targetedConstraints)));
        }
        return CollectionUtil.unmodifiableList(scopedConstraints);
    }

    private static AssemblyTargetedConstraints handleScopedAssembly(@NonNull MetaschemaModuleConstraints.Scope.Assembly obj, @NonNull ISource source) {
        AssemblyConstraintSet constraints = new AssemblyConstraintSet();
        ConstraintBindingSupport.parse((IModelConstrained)constraints, obj, source);
        return new AssemblyTargetedConstraints((String)ObjectUtils.requireNonNull((Object)obj.getTarget()), (IModelConstrained)constraints);
    }

    private static FieldTargetedConstraints handleScopedField(@NonNull MetaschemaModuleConstraints.Scope.Field obj, @NonNull ISource source) {
        ValueConstraintSet constraints = new ValueConstraintSet();
        ConstraintBindingSupport.parse((IValueConstrained)constraints, obj, source);
        return new FieldTargetedConstraints((String)ObjectUtils.requireNonNull((Object)obj.getTarget()), (IValueConstrained)constraints);
    }

    private static FlagTargetedConstraints handleScopedFlag(@NonNull MetaschemaModuleConstraints.Scope.Flag obj, @NonNull ISource source) {
        ValueConstraintSet constraints = new ValueConstraintSet();
        ConstraintBindingSupport.parse((IValueConstrained)constraints, obj, source);
        return new FlagTargetedConstraints((String)ObjectUtils.requireNonNull((Object)obj.getTarget()), (IValueConstrained)constraints);
    }

    private Context parseContext(@NonNull MetapathContext contextObj, @Nullable Context parent, @NonNull ISource source) {
        List metapaths;
        if (parent == null) {
            metapaths = (List)ObjectUtils.notNull(CollectionUtil.listOrEmpty(contextObj.getMetapaths()).stream().map(MetaschemaMetapath::getTarget).collect(Collectors.toList()));
        } else {
            List parentMetapaths = parent.getMetapaths().stream().collect(Collectors.toList());
            metapaths = (List)ObjectUtils.notNull(CollectionUtil.listOrEmpty(contextObj.getMetapaths()).stream().map(MetaschemaMetapath::getTarget).flatMap(childPath -> parentMetapaths.stream().map(parentPath -> parentPath + "/" + childPath)).collect(Collectors.toList()));
        }
        AssemblyConstraints contextConstraints = contextObj.getConstraints();
        AssemblyConstraintSet constraints = new AssemblyConstraintSet();
        if (contextConstraints != null) {
            ConstraintBindingSupport.parse((IModelConstrained)constraints, contextConstraints, source);
        }
        Context context = new Context(metapaths, (IModelConstrained)constraints);
        List childContexts = (List)ObjectUtils.notNull(CollectionUtil.listOrEmpty(contextObj.getContexts()).stream().map(childObj -> this.parseContext((MetapathContext)ObjectUtils.notNull((Object)childObj), context, source)).collect(Collectors.toList()));
        context.addAll(childContexts);
        return context;
    }

    private static final class MetaConstraintSet
    implements IConstraintSet {
        @NonNull
        private final List<ITargetedConstraints> targetedConstraints;

        private MetaConstraintSet(@NonNull List<ITargetedConstraints> targetedConstraints) {
            this.targetedConstraints = targetedConstraints;
        }

        public Iterable<ITargetedConstraints> getTargetedConstraintsForModule(IModule module) {
            return this.targetedConstraints;
        }

        public Collection<IConstraintSet> getImportedConstraintSets() {
            return CollectionUtil.emptyList();
        }
    }

    private static class Context {
        @NonNull
        private final List<String> metapaths;
        @NonNull
        private final List<Context> childContexts = new LinkedList<Context>();
        @NonNull
        private final Lazy<List<ITargetedConstraints>> targetedConstraints;

        public Context(@NonNull List<String> metapaths, @NonNull IModelConstrained constraints) {
            this.metapaths = metapaths;
            this.targetedConstraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
                Stream<ITargetedConstraints> paths = this.getMetapaths().stream().map(metapath -> new MetaTargetedContraints((String)ObjectUtils.notNull((Object)metapath), constraints));
                Stream childPaths = this.childContexts.stream().flatMap(child -> child.getTargetedConstraints().stream());
                return Stream.concat(paths, childPaths).collect(Collectors.toUnmodifiableList());
            }));
        }

        @NonNull
        public List<ITargetedConstraints> getTargetedConstraints() {
            return (List)ObjectUtils.notNull((Object)((List)this.targetedConstraints.get()));
        }

        public void addAll(@NonNull Collection<Context> childContexts) {
            childContexts.addAll(childContexts);
        }

        @NonNull
        public List<String> getMetapaths() {
            return this.metapaths;
        }
    }

    private static class MetaTargetedContraints
    extends AbstractTargetedConstraints<IModelConstrained>
    implements IFeatureModelConstrained {
        protected MetaTargetedContraints(@NonNull String target, @NonNull IModelConstrained constraints) {
            super(target, (IValueConstrained)constraints);
        }

        protected void applyTo(@NonNull IDefinition definition) {
            this.getLetExpressions().values().forEach(arg_0 -> ((IDefinition)definition).addLetExpression(arg_0));
            this.getAllowedValuesConstraints().forEach(arg_0 -> ((IDefinition)definition).addConstraint(arg_0));
            this.getMatchesConstraints().forEach(arg_0 -> ((IDefinition)definition).addConstraint(arg_0));
            this.getIndexHasKeyConstraints().forEach(arg_0 -> ((IDefinition)definition).addConstraint(arg_0));
            this.getExpectConstraints().forEach(arg_0 -> ((IDefinition)definition).addConstraint(arg_0));
        }

        protected void applyTo(@NonNull IAssemblyDefinition definition) {
            this.applyTo((IDefinition)definition);
            this.getIndexConstraints().forEach(arg_0 -> ((IAssemblyDefinition)definition).addConstraint(arg_0));
            this.getUniqueConstraints().forEach(arg_0 -> ((IAssemblyDefinition)definition).addConstraint(arg_0));
            this.getHasCardinalityConstraints().forEach(arg_0 -> ((IAssemblyDefinition)definition).addConstraint(arg_0));
        }

        public void target(IFlagDefinition definition) {
            this.applyTo((IDefinition)definition);
        }

        public void target(IFieldDefinition definition) {
            this.applyTo((IDefinition)definition);
        }

        public void target(IAssemblyDefinition definition) {
            this.applyTo(definition);
        }
    }
}

