/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.configuration.IMutableConfiguration;
import gov.nist.secauto.metaschema.core.model.AbstractModuleLoader;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.io.DeserializationFeature;
import gov.nist.secauto.metaschema.databind.io.IBoundLoader;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingModuleLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.ModuleLoadingPostProcessor;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.METASCHEMA;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.BindingModule;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.talsmasoftware.lazy4j.Lazy;

public class BindingModuleLoader
extends AbstractModuleLoader<METASCHEMA, IBindingMetaschemaModule>
implements IBindingModuleLoader {
    private final Lazy<IBoundLoader> loader = Lazy.lazy(bindingContext::newBoundLoader);
    private final ModuleLoadingPostProcessor postProcessor;

    public BindingModuleLoader(@NonNull IBindingContext bindingContext, @NonNull ModuleLoadingPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    @Override
    @NonNull
    public IBindingContext getBindingContext() {
        return this.getLoader().getBindingContext();
    }

    protected IBindingMetaschemaModule newModule(URI resource, METASCHEMA binding, List<? extends IBindingMetaschemaModule> importedModules) throws MetaschemaException {
        IBindingContext bindingContext = this.getLoader().getBindingContext();
        BindingModule module = new BindingModule(resource, (IBoundDefinitionModelAssembly)ObjectUtils.notNull((Object)((IBoundDefinitionModelAssembly)bindingContext.getBoundDefinitionForClass(METASCHEMA.class))), binding, importedModules);
        this.postProcessor.postProcessModule((IModule)module, bindingContext);
        return module;
    }

    protected List<URI> getImports(METASCHEMA binding) {
        return (List)ObjectUtils.notNull(binding.getImports().stream().map(METASCHEMA.Import::getHref).collect(Collectors.toUnmodifiableList()));
    }

    protected METASCHEMA parseModule(URI resource) throws IOException {
        return this.getLoader().load(METASCHEMA.class, resource);
    }

    protected IBoundLoader getLoader() {
        return (IBoundLoader)ObjectUtils.notNull((Object)((IBoundLoader)this.loader.get()));
    }

    public boolean isFeatureEnabled(DeserializationFeature<?> feature) {
        return this.getLoader().isFeatureEnabled((IConfigurationFeature)feature);
    }

    public Map<DeserializationFeature<?>, Object> getFeatureValues() {
        return this.getLoader().getFeatureValues();
    }

    public IMutableConfiguration<DeserializationFeature<?>> applyConfiguration(IConfiguration<DeserializationFeature<?>> other) {
        return this.getLoader().applyConfiguration((IConfiguration)other);
    }

    public IMutableConfiguration<DeserializationFeature<?>> set(DeserializationFeature<?> feature, Object value) {
        return this.getLoader().set(feature, value);
    }

    @Override
    public void allowEntityResolution() {
        this.enableFeature((IConfigurationFeature)DeserializationFeature.DESERIALIZE_XML_ALLOW_ENTITY_RESOLUTION);
    }
}

