/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.binding;

import gov.nist.secauto.metaschema.core.datatype.adapter.NonNegativeIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.PositiveIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Example;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FlagReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.GroupingAs;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.InlineDefineFlag;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.JsonKey;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Property;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Remarks;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Inline Assembly Definition", name="inline-define-assembly", moduleClass=MetaschemaModelModule.class)
public class InlineDefineAssembly
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Inline Assembly Name", name="name", required=true, typeAdapter=TokenAdapter.class)
    private String _name;
    @BoundFlag(formalName="Inline Assembly Binary Name", name="index", typeAdapter=PositiveIntegerAdapter.class)
    private BigInteger _index;
    @BoundFlag(formalName="Deprecated Version", name="deprecated", typeAdapter=StringAdapter.class)
    private String _deprecated;
    @BoundFlag(formalName="Minimum Occurrence", name="min-occurs", defaultValue="0", typeAdapter=NonNegativeIntegerAdapter.class)
    private BigInteger _minOccurs;
    @BoundFlag(formalName="Maximum Occurrence", name="max-occurs", defaultValue="1", typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(matches={@Matches(level=IConstraint.Level.ERROR, pattern="^[1-9][0-9]*|unbounded$")}))
    private String _maxOccurs;
    @BoundField(formalName="Formal Name", description="A formal name for the data construct, to be presented in documentation.", useName="formal-name")
    private String _formalName;
    @BoundField(formalName="Description", description="A short description of the data construct's purpose, describing the constructs semantics.", useName="description", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _description;
    @BoundAssembly(formalName="Property", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundAssembly(formalName="JSON Key", description="Used in JSON (and similar formats) to identify a flag that will be used as the property name in an object hold a collection of sibling objects. Requires that siblings must never share `json-key` values.", useName="json-key")
    private JsonKey _jsonKey;
    @BoundAssembly(formalName="Group As", useName="group-as")
    private GroupingAs _groupAs;
    @BoundChoiceGroup(maxOccurs=-1, assemblies={@BoundGroupedAssembly(formalName="Inline Flag Definition", useName="define-flag", binding=InlineDefineFlag.class), @BoundGroupedAssembly(formalName="Flag Reference", useName="flag", binding=FlagReference.class)}, groupAs=@GroupAs(name="flags", inJson=JsonGroupAsBehavior.LIST))
    private List<Object> _flags;
    @BoundAssembly(useName="model")
    private AssemblyModel _model;
    @BoundAssembly(useName="constraint")
    private AssemblyConstraints _constraint;
    @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
    private Remarks _remarks;
    @BoundAssembly(formalName="Example", useName="example", maxOccurs=-1, groupAs=@GroupAs(name="examples", inJson=JsonGroupAsBehavior.LIST))
    private List<Example> _examples;

    public InlineDefineAssembly() {
        this(null);
    }

    public InlineDefineAssembly(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    public BigInteger getIndex() {
        return this._index;
    }

    public void setIndex(BigInteger value) {
        this._index = value;
    }

    public String getDeprecated() {
        return this._deprecated;
    }

    public void setDeprecated(String value) {
        this._deprecated = value;
    }

    public BigInteger getMinOccurs() {
        return this._minOccurs;
    }

    public void setMinOccurs(BigInteger value) {
        this._minOccurs = value;
    }

    public String getMaxOccurs() {
        return this._maxOccurs;
    }

    public void setMaxOccurs(String value) {
        this._maxOccurs = value;
    }

    public String getFormalName() {
        return this._formalName;
    }

    public void setFormalName(String value) {
        this._formalName = value;
    }

    public MarkupLine getDescription() {
        return this._description;
    }

    public void setDescription(MarkupLine value) {
        this._description = value;
    }

    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    public JsonKey getJsonKey() {
        return this._jsonKey;
    }

    public void setJsonKey(JsonKey value) {
        this._jsonKey = value;
    }

    public GroupingAs getGroupAs() {
        return this._groupAs;
    }

    public void setGroupAs(GroupingAs value) {
        this._groupAs = value;
    }

    public List<Object> getFlags() {
        return this._flags;
    }

    public void setFlags(List<Object> value) {
        this._flags = value;
    }

    public AssemblyModel getModel() {
        return this._model;
    }

    public void setModel(AssemblyModel value) {
        this._model = value;
    }

    public AssemblyConstraints getConstraint() {
        return this._constraint;
    }

    public void setConstraint(AssemblyConstraints value) {
        this._constraint = value;
    }

    public Remarks getRemarks() {
        return this._remarks;
    }

    public void setRemarks(Remarks value) {
        this._remarks = value;
    }

    public List<Example> getExamples() {
        return this._examples;
    }

    public void setExamples(List<Example> value) {
        this._examples = value;
    }

    public boolean addExample(Example item) {
        Example value = (Example)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._examples == null) {
            this._examples = new LinkedList<Example>();
        }
        return this._examples.add(value);
    }

    public boolean removeExample(Example item) {
        Example value = (Example)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._examples != null && this._examples.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

