/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.binding;

import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaMetapath;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Remarks;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(name="metapath-context", moduleClass=MetaschemaModelModule.class)
public class MetapathContext
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(description="A Metapath expression identifying the model node that the constraints will be applied to.", useName="metapath", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="metapaths", inJson=JsonGroupAsBehavior.LIST))
    private List<MetaschemaMetapath> _metapaths;
    @BoundAssembly(useName="constraints")
    private AssemblyConstraints _constraints;
    @BoundAssembly(useName="context", maxOccurs=-1, groupAs=@GroupAs(name="contexts", inJson=JsonGroupAsBehavior.LIST))
    private List<MetapathContext> _contexts;
    @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
    private Remarks _remarks;

    public MetapathContext() {
        this(null);
    }

    public MetapathContext(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<MetaschemaMetapath> getMetapaths() {
        return this._metapaths;
    }

    public void setMetapaths(List<MetaschemaMetapath> value) {
        this._metapaths = value;
    }

    public boolean addMetapath(MetaschemaMetapath item) {
        MetaschemaMetapath value = (MetaschemaMetapath)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._metapaths == null) {
            this._metapaths = new LinkedList<MetaschemaMetapath>();
        }
        return this._metapaths.add(value);
    }

    public boolean removeMetapath(MetaschemaMetapath item) {
        MetaschemaMetapath value = (MetaschemaMetapath)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._metapaths != null && this._metapaths.remove(value);
    }

    public AssemblyConstraints getConstraints() {
        return this._constraints;
    }

    public void setConstraints(AssemblyConstraints value) {
        this._constraints = value;
    }

    public List<MetapathContext> getContexts() {
        return this._contexts;
    }

    public void setContexts(List<MetapathContext> value) {
        this._contexts = value;
    }

    public boolean addContext(MetapathContext item) {
        MetapathContext value = (MetapathContext)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._contexts == null) {
            this._contexts = new LinkedList<MetapathContext>();
        }
        return this._contexts.add(value);
    }

    public boolean removeContext(MetapathContext item) {
        MetapathContext value = (MetapathContext)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._contexts != null && this._contexts.remove(value);
    }

    public Remarks getRemarks() {
        return this._remarks;
    }

    public void setRemarks(Remarks value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

