/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.binding;

import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.UriReferenceAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.Expect;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.IsUnique;
import gov.nist.secauto.metaschema.databind.model.annotations.KeyField;
import gov.nist.secauto.metaschema.databind.model.annotations.Let;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetapathContext;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetapathNamespace;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Remarks;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="External Module Constraints", description="Defines constraint rules to be applied to an existing set of Metaschema module-based models.", name="metaschema-meta-constraints", moduleClass=MetaschemaModelModule.class, rootName="metaschema-meta-constraints", valueConstraints=@ValueConstraints(lets={@Let(name="deprecated-type-map", target="map { 'base64Binary':'base64','dateTime':'date-time','dateTime-with-timezone':'date-time-with-timezone','email':'email-address','nonNegativeInteger':'non-negative-integer','positiveInteger':'positive-integer' }")}, expect={@Expect(id="metaschema-deprecated-types", formalName="Avoid Deprecated Data Type Use", description="Ensure that the data type specified is not one of the legacy Metaschema data types which have been deprecated (i.e. base64Binary, dateTime, dateTime-with-timezone, email, nonNegativeInteger, positiveInteger).", level=IConstraint.Level.WARNING, target=".//matches/@datatype|.//(define-field|define-flag)/@as-type", test="not(.=('base64Binary','dateTime','dateTime-with-timezone','email','nonNegativeInteger','positiveInteger'))", message="Use of the type '{ . }' is deprecated. Use '{ $deprecated-type-map(.)}' instead.")}), modelConstraints=@gov.nist.secauto.metaschema.databind.model.annotations.AssemblyConstraints(unique={@IsUnique(id="meta-constraints-namespace-unique-entry", formalName="Require Unique Namespace Entries", description="Ensures that all declared namespace entries are unique.", level=IConstraint.Level.ERROR, target="namespace-binding", keyFields={@KeyField(target="@prefix"), @KeyField(target="@uri")}), @IsUnique(id="meta-constraints-namespace-unique-prefix", formalName="Require Unique Namespace Entry Prefixes", description="Ensures that all declared namespace entries have a unique prefix.", level=IConstraint.Level.ERROR, target="namespace-binding", keyFields={@KeyField(target="@prefix")})}))
public class MetaschemaMetaConstraints
implements IBoundObject {
    private final IMetaschemaData __metaschemaData;
    @BoundAssembly(description="Declares a set of Metaschema constraints from an out-of-line resource to import, supporting composition of constraint sets.", useName="import", maxOccurs=-1, groupAs=@GroupAs(name="imports", inJson=JsonGroupAsBehavior.LIST))
    private List<Import> _imports;
    @BoundAssembly(formalName="Metapath Namespace Declaration", description="Assigns a Metapath namespace to a prefix for use in a Metapath expression in a lexical qualified name.", useName="namespace-binding", maxOccurs=-1, groupAs=@GroupAs(name="namespace-bindings"))
    private List<MetapathNamespace> _namespaceBindings;
    @BoundAssembly(useName="definition-context")
    private DefinitionContext _definitionContext;
    @BoundAssembly(useName="context", minOccurs=1, maxOccurs=-1, groupAs=@GroupAs(name="contexts", inJson=JsonGroupAsBehavior.LIST))
    private List<MetapathContext> _contexts;

    public MetaschemaMetaConstraints() {
        this(null);
    }

    public MetaschemaMetaConstraints(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    public List<Import> getImports() {
        return this._imports;
    }

    public void setImports(List<Import> value) {
        this._imports = value;
    }

    public boolean addImport(Import item) {
        Import value = (Import)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._imports == null) {
            this._imports = new LinkedList<Import>();
        }
        return this._imports.add(value);
    }

    public boolean removeImport(Import item) {
        Import value = (Import)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._imports != null && this._imports.remove(value);
    }

    public List<MetapathNamespace> getNamespaceBindings() {
        return this._namespaceBindings;
    }

    public void setNamespaceBindings(List<MetapathNamespace> value) {
        this._namespaceBindings = value;
    }

    public boolean addNamespaceBinding(MetapathNamespace item) {
        MetapathNamespace value = (MetapathNamespace)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._namespaceBindings == null) {
            this._namespaceBindings = new LinkedList<MetapathNamespace>();
        }
        return this._namespaceBindings.add(value);
    }

    public boolean removeNamespaceBinding(MetapathNamespace item) {
        MetapathNamespace value = (MetapathNamespace)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._namespaceBindings != null && this._namespaceBindings.remove(value);
    }

    public DefinitionContext getDefinitionContext() {
        return this._definitionContext;
    }

    public void setDefinitionContext(DefinitionContext value) {
        this._definitionContext = value;
    }

    public List<MetapathContext> getContexts() {
        return this._contexts;
    }

    public void setContexts(List<MetapathContext> value) {
        this._contexts = value;
    }

    public boolean addContext(MetapathContext item) {
        MetapathContext value = (MetapathContext)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._contexts == null) {
            this._contexts = new LinkedList<MetapathContext>();
        }
        return this._contexts.add(value);
    }

    public boolean removeContext(MetapathContext item) {
        MetapathContext value = (MetapathContext)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._contexts != null && this._contexts.remove(value);
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }

    @MetaschemaAssembly(description="Declares a set of Metaschema constraints from an out-of-line resource to import, supporting composition of constraint sets.", name="import", moduleClass=MetaschemaModelModule.class)
    public static class Import
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(description="A relative or absolute URI for retrieving an out-of-line Metaschema constraint definition.", name="href", required=true, typeAdapter=UriReferenceAdapter.class)
        private URI _href;

        public Import() {
            this(null);
        }

        public Import(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public URI getHref() {
            return this._href;
        }

        public void setHref(URI value) {
            this._href = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }

    @MetaschemaAssembly(name="definition-context", moduleClass=MetaschemaModelModule.class)
    public static class DefinitionContext
    implements IBoundObject {
        private final IMetaschemaData __metaschemaData;
        @BoundFlag(name="name", required=true, typeAdapter=TokenAdapter.class)
        private String _name;
        @BoundFlag(name="namespace", required=true, typeAdapter=UriAdapter.class)
        private URI _namespace;
        @BoundAssembly(useName="constraints", minOccurs=1)
        private AssemblyConstraints _constraints;
        @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
        private Remarks _remarks;

        public DefinitionContext() {
            this(null);
        }

        public DefinitionContext(IMetaschemaData data) {
            this.__metaschemaData = data;
        }

        public IMetaschemaData getMetaschemaData() {
            return this.__metaschemaData;
        }

        public String getName() {
            return this._name;
        }

        public void setName(String value) {
            this._name = value;
        }

        public URI getNamespace() {
            return this._namespace;
        }

        public void setNamespace(URI value) {
            this._namespace = value;
        }

        public AssemblyConstraints getConstraints() {
            return this._constraints;
        }

        public void setConstraints(AssemblyConstraints value) {
            this._constraints = value;
        }

        public Remarks getRemarks() {
            return this._remarks;
        }

        public void setRemarks(Remarks value) {
            this._remarks = value;
        }

        public String toString() {
            return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
        }
    }
}

