/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.binding;

import gov.nist.secauto.metaschema.core.datatype.adapter.NonNegativeIntegerAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.TokenAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLineAdapter;
import gov.nist.secauto.metaschema.core.model.IBoundObject;
import gov.nist.secauto.metaschema.core.model.IMetaschemaData;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValue;
import gov.nist.secauto.metaschema.databind.model.annotations.AllowedValues;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundField;
import gov.nist.secauto.metaschema.databind.model.annotations.BoundFlag;
import gov.nist.secauto.metaschema.databind.model.annotations.GroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.Matches;
import gov.nist.secauto.metaschema.databind.model.annotations.MetaschemaAssembly;
import gov.nist.secauto.metaschema.databind.model.annotations.ValueConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.IConfigurableMessageConstraintBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.ITargetedConstraintBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Property;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Remarks;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@MetaschemaAssembly(formalName="Targeted Cardinality Constraint", name="targeted-has-cardinality-constraint", moduleClass=MetaschemaModelModule.class)
public class TargetedHasCardinalityConstraint
implements IBoundObject,
ITargetedConstraintBase,
IConfigurableMessageConstraintBase {
    private final IMetaschemaData __metaschemaData;
    @BoundFlag(formalName="Constraint Identifier", name="id", typeAdapter=TokenAdapter.class)
    private String _id;
    @BoundFlag(formalName="Constraint Severity Level", name="level", defaultValue="ERROR", typeAdapter=TokenAdapter.class, valueConstraints=@ValueConstraints(allowedValues={@AllowedValues(level=IConstraint.Level.ERROR, values={@AllowedValue(value="CRITICAL", description="A violation of the constraint represents a serious fault in the content that will prevent typical use of the content."), @AllowedValue(value="ERROR", description="A violation of the constraint represents a fault in the content. This may include issues around compatibility, integrity, consistency, etc."), @AllowedValue(value="WARNING", description="A violation of the constraint represents a potential issue with the content."), @AllowedValue(value="INFORMATIONAL", description="A violation of the constraint represents a point of interest."), @AllowedValue(value="DEBUG", description="A violation of the constraint represents a fault in the content that may warrant review by a developer when performing model or tool development.")})}))
    private String _level;
    @BoundFlag(formalName="Minimum Occurrence", name="min-occurs", typeAdapter=NonNegativeIntegerAdapter.class)
    private BigInteger _minOccurs;
    @BoundFlag(formalName="Maximum Occurrence", name="max-occurs", typeAdapter=StringAdapter.class, valueConstraints=@ValueConstraints(matches={@Matches(level=IConstraint.Level.ERROR, pattern="^[1-9][0-9]*|unbounded$")}))
    private String _maxOccurs;
    @BoundFlag(formalName="Constraint Target Metapath Expression", name="target", required=true, typeAdapter=StringAdapter.class)
    private String _target;
    @BoundField(formalName="Formal Name", description="A formal name for the data construct, to be presented in documentation.", useName="formal-name")
    private String _formalName;
    @BoundField(formalName="Description", description="A short description of the data construct's purpose, describing the constructs semantics.", useName="description", typeAdapter=MarkupLineAdapter.class)
    private MarkupLine _description;
    @BoundAssembly(formalName="Property", useName="prop", maxOccurs=-1, groupAs=@GroupAs(name="props", inJson=JsonGroupAsBehavior.LIST))
    private List<Property> _props;
    @BoundField(formalName="Constraint Condition Violation Message", useName="message")
    private String _message;
    @BoundField(formalName="Remarks", description="Any explanatory or helpful information to be provided about the remarks parent.", useName="remarks")
    private Remarks _remarks;

    public TargetedHasCardinalityConstraint() {
        this(null);
    }

    public TargetedHasCardinalityConstraint(IMetaschemaData data) {
        this.__metaschemaData = data;
    }

    public IMetaschemaData getMetaschemaData() {
        return this.__metaschemaData;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setId(String value) {
        this._id = value;
    }

    @Override
    public String getLevel() {
        return this._level;
    }

    public void setLevel(String value) {
        this._level = value;
    }

    public BigInteger getMinOccurs() {
        return this._minOccurs;
    }

    public void setMinOccurs(BigInteger value) {
        this._minOccurs = value;
    }

    public String getMaxOccurs() {
        return this._maxOccurs;
    }

    public void setMaxOccurs(String value) {
        this._maxOccurs = value;
    }

    @Override
    public String getTarget() {
        return this._target;
    }

    public void setTarget(String value) {
        this._target = value;
    }

    @Override
    public String getFormalName() {
        return this._formalName;
    }

    public void setFormalName(String value) {
        this._formalName = value;
    }

    @Override
    public MarkupLine getDescription() {
        return this._description;
    }

    public void setDescription(MarkupLine value) {
        this._description = value;
    }

    @Override
    public List<Property> getProps() {
        return this._props;
    }

    public void setProps(List<Property> value) {
        this._props = value;
    }

    public boolean addProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        if (this._props == null) {
            this._props = new LinkedList<Property>();
        }
        return this._props.add(value);
    }

    public boolean removeProp(Property item) {
        Property value = (Property)ObjectUtils.requireNonNull((Object)item, (String)"item cannot be null");
        return this._props != null && this._props.remove(value);
    }

    @Override
    public String getMessage() {
        return this._message;
    }

    public void setMessage(String value) {
        this._message = value;
    }

    @Override
    public Remarks getRemarks() {
        return this._remarks;
    }

    public void setRemarks(Remarks value) {
        this._remarks = value;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

