/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IChoiceInstance;
import gov.nist.secauto.metaschema.core.model.IContainerModelAbsolute;
import gov.nist.secauto.metaschema.core.model.IContainerModelSupport;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceAbsolute;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FieldReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceModelAssemblyReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceModelFieldReference;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public abstract class AbstractBindingModelContainerSupport
implements IContainerModelSupport<IModelInstanceAbsolute, INamedModelInstanceAbsolute, IFieldInstanceAbsolute, IAssemblyInstanceAbsolute> {
    protected static void addInstance(@NonNull IAssemblyInstanceAbsolute assembly, @NonNull List<IModelInstanceAbsolute> modelInstances, @NonNull Map<QName, INamedModelInstanceAbsolute> namedModelInstances, @NonNull Map<QName, IAssemblyInstanceAbsolute> assemblyInstances) {
        QName effectiveName = assembly.getXmlQName();
        modelInstances.add((IModelInstanceAbsolute)assembly);
        namedModelInstances.put(effectiveName, (INamedModelInstanceAbsolute)assembly);
        assemblyInstances.put(effectiveName, assembly);
    }

    protected static void addInstance(@NonNull IFieldInstanceAbsolute field, @NonNull List<IModelInstanceAbsolute> modelInstances, @NonNull Map<QName, INamedModelInstanceAbsolute> namedModelInstances, @NonNull Map<QName, IFieldInstanceAbsolute> fieldInstances) {
        QName effectiveName = field.getXmlQName();
        modelInstances.add((IModelInstanceAbsolute)field);
        namedModelInstances.put(effectiveName, (INamedModelInstanceAbsolute)field);
        fieldInstances.put(effectiveName, field);
    }

    protected static void addInstance(@NonNull IChoiceInstance choice, @NonNull List<IModelInstanceAbsolute> modelInstances, @NonNull List<IChoiceInstance> choiceInstances) {
        modelInstances.add((IModelInstanceAbsolute)choice);
        choiceInstances.add(choice);
    }

    protected static void addInstance(@NonNull IChoiceGroupInstance choiceGroup, @NonNull List<IModelInstanceAbsolute> modelInstances, @NonNull Map<String, IChoiceGroupInstance> choiceGroupInstances) {
        modelInstances.add((IModelInstanceAbsolute)choiceGroup);
        choiceGroupInstances.put(choiceGroup.getGroupAsName(), choiceGroup);
    }

    @NonNull
    protected static IAssemblyInstanceAbsolute newInstance(@NonNull AssemblyReference obj, @NonNull IBoundInstanceModelGroupedAssembly objInstance, int position, @NonNull IContainerModelAbsolute parent) {
        String name;
        IAssemblyDefinition owningDefinition = parent.getOwningDefinition();
        IModule module = owningDefinition.getContainingModule();
        IAssemblyDefinition definition = module.getScopedAssemblyDefinitionByName(module.toModelQName(name = (String)ObjectUtils.requireNonNull((Object)obj.getRef())));
        if (definition == null) {
            throw new IllegalStateException(String.format("Unable to resolve assembly reference '%s' in definition '%s' in module '%s'", name, owningDefinition.getName(), module.getShortName()));
        }
        return new InstanceModelAssemblyReference(obj, objInstance, position, definition, parent);
    }

    @NonNull
    protected static IFieldInstanceAbsolute newInstance(@NonNull FieldReference obj, @NonNull IBoundInstanceModelGroupedAssembly objInstance, int position, @NonNull IContainerModelAbsolute parent) {
        String name;
        IAssemblyDefinition owningDefinition = parent.getOwningDefinition();
        IModule module = owningDefinition.getContainingModule();
        IFieldDefinition definition = module.getScopedFieldDefinitionByName(module.toModelQName(name = (String)ObjectUtils.requireNonNull((Object)obj.getRef())));
        if (definition == null) {
            throw new IllegalStateException(String.format("Unable to resolve field reference '%s' in definition '%s' in module '%s'", name, owningDefinition.getName(), module.getShortName()));
        }
        return new InstanceModelFieldReference(obj, objInstance, position, definition, parent);
    }
}

