/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.StaticContext;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IModuleNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.AbstractModule;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.METASCHEMA;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetapathNamespace;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.DefinitionAssemblyGlobal;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.DefinitionFieldGlobal;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.DefinitionFlagGlobal;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ModelSupport;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public class BindingModule
extends AbstractModule<IBindingMetaschemaModule, IModelDefinition, IFlagDefinition, IFieldDefinition, IAssemblyDefinition>
implements IBindingMetaschemaModule {
    @NonNull
    private final Lazy<StaticContext> staticContext;
    @NonNull
    private final METASCHEMA binding;
    @NonNull
    private final Lazy<IDocumentNodeItem> documentNodeItem;
    @NonNull
    private final Lazy<IModuleNodeItem> moduleNodeItem;
    @NonNull
    private final Lazy<Definitions> definitions;
    @NonNull
    private final ISource source;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public BindingModule(@NonNull URI resource, @NonNull IBoundDefinitionModelAssembly rootDefinition, @NonNull METASCHEMA binding, @NonNull List<? extends IBindingMetaschemaModule> importedModules) throws MetaschemaException {
        super(importedModules);
        this.binding = binding;
        this.staticContext = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            StaticContext.Builder builder = StaticContext.builder().baseUri(resource).defaultModelNamespace(this.getXmlNamespace());
            this.getNamespaceBindings().forEach((prefix, ns) -> builder.namespace((String)ObjectUtils.notNull((Object)prefix), (String)ObjectUtils.notNull((Object)ns)));
            return builder.build();
        }));
        INodeItemFactory nodeItemFactory = INodeItemFactory.instance();
        this.definitions = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> new Definitions(resource, rootDefinition, nodeItemFactory)));
        this.documentNodeItem = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> nodeItemFactory.newDocumentNodeItem((IAssemblyDefinition)rootDefinition, resource, (Object)binding)));
        this.moduleNodeItem = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> nodeItemFactory.newModuleNodeItem((IModule)this)));
        this.source = ISource.moduleSource((IModule)this);
    }

    public ISource getSource() {
        return this.source;
    }

    @Override
    public final METASCHEMA getBinding() {
        return this.binding;
    }

    @Override
    public IDocumentNodeItem getSourceNodeItem() {
        return (IDocumentNodeItem)ObjectUtils.notNull((Object)((IDocumentNodeItem)this.documentNodeItem.get()));
    }

    @Override
    public IModuleNodeItem getModuleNodeItem() {
        return (IModuleNodeItem)ObjectUtils.notNull((Object)((IModuleNodeItem)this.moduleNodeItem.get()));
    }

    public final StaticContext getModuleStaticContext() {
        return (StaticContext)ObjectUtils.notNull((Object)((StaticContext)this.staticContext.get()));
    }

    @NonNull
    public final URI getLocation() {
        return (URI)ObjectUtils.notNull((Object)this.getModuleStaticContext().getBaseUri());
    }

    public MarkupLine getName() {
        MarkupLine retval = this.getBinding().getSchemaName();
        if (retval == null) {
            throw new IllegalStateException(String.format("The schema name is NULL for module '%s'.", this.getLocation()));
        }
        return retval;
    }

    public String getVersion() {
        String retval = this.getBinding().getSchemaVersion();
        if (retval == null) {
            throw new IllegalStateException(String.format("The schema version is NULL for module '%s'.", this.getLocation()));
        }
        return retval;
    }

    public MarkupMultiline getRemarks() {
        return ModelSupport.remarks(this.getBinding().getRemarks());
    }

    public String getShortName() {
        String retval = this.getBinding().getShortName();
        if (retval == null) {
            throw new IllegalStateException(String.format("The schema short name is NULL for module '%s'.", this.getLocation()));
        }
        return retval;
    }

    public final URI getXmlNamespace() {
        URI retval = this.getBinding().getNamespace();
        if (retval == null) {
            throw new IllegalStateException(String.format("The XML schema namespace is NULL for module '%s'.", this.getLocation()));
        }
        return retval;
    }

    public URI getJsonBaseUri() {
        URI retval = this.getBinding().getJsonBaseUri();
        if (retval == null) {
            throw new IllegalStateException(String.format("The JSON schema URI is NULL for module '%s'.", this.getLocation()));
        }
        return retval;
    }

    public Map<String, String> getNamespaceBindings() {
        return (Map)ObjectUtils.notNull((Object)CollectionUtil.listOrEmpty(this.binding.getNamespaceBindings()).stream().collect(Collectors.toMap(MetapathNamespace::getPrefix, binding -> binding.getUri().toASCIIString(), (v1, v2) -> v2, LinkedHashMap::new)));
    }

    @NonNull
    private Definitions getDefinitions() {
        return (Definitions)ObjectUtils.notNull((Object)((Definitions)this.definitions.get()));
    }

    @NonNull
    private Map<QName, IAssemblyDefinition> getAssemblyDefinitionMap() {
        return this.getDefinitions().assemblyDefinitions;
    }

    public Collection<IAssemblyDefinition> getAssemblyDefinitions() {
        return (Collection)ObjectUtils.notNull(this.getAssemblyDefinitionMap().values());
    }

    public IAssemblyDefinition getAssemblyDefinitionByName(@NonNull QName name) {
        return this.getAssemblyDefinitionMap().get(name);
    }

    @NonNull
    private Map<QName, IFieldDefinition> getFieldDefinitionMap() {
        return this.getDefinitions().fieldDefinitions;
    }

    public Collection<IFieldDefinition> getFieldDefinitions() {
        return this.getFieldDefinitionMap().values();
    }

    public IFieldDefinition getFieldDefinitionByName(@NonNull QName name) {
        return this.getFieldDefinitionMap().get(name);
    }

    public List<IModelDefinition> getAssemblyAndFieldDefinitions() {
        return Stream.concat(this.getAssemblyDefinitions().stream(), this.getFieldDefinitions().stream()).collect(Collectors.toList());
    }

    @NonNull
    private Map<QName, IFlagDefinition> getFlagDefinitionMap() {
        return this.getDefinitions().flagDefinitions;
    }

    public Collection<IFlagDefinition> getFlagDefinitions() {
        return this.getFlagDefinitionMap().values();
    }

    public IFlagDefinition getFlagDefinitionByName(@NonNull QName name) {
        return this.getFlagDefinitionMap().get(name);
    }

    private Map<QName, ? extends IAssemblyDefinition> getRootAssemblyDefinitionMap() {
        return this.getDefinitions().rootAssemblyDefinitions;
    }

    public Collection<? extends IAssemblyDefinition> getRootAssemblyDefinitions() {
        return this.getRootAssemblyDefinitionMap().values();
    }

    private final class Definitions {
        @NonNull
        private final Map<QName, IFlagDefinition> flagDefinitions = new LinkedHashMap<QName, IFlagDefinition>();
        @NonNull
        private final Map<QName, IFieldDefinition> fieldDefinitions = new LinkedHashMap<QName, IFieldDefinition>();
        @NonNull
        private final Map<QName, IAssemblyDefinition> assemblyDefinitions = new LinkedHashMap<QName, IAssemblyDefinition>();
        @NonNull
        private final Map<QName, IAssemblyDefinition> rootAssemblyDefinitions = new LinkedHashMap<QName, IAssemblyDefinition>();

        private Definitions(@NonNull URI resource, @NonNull IBoundDefinitionModelAssembly rootDefinition, INodeItemFactory nodeItemFactory) {
            int globalFlagPosition = 0;
            int globalFieldPosition = 0;
            int globalAssemblyPosition = 0;
            IBoundInstanceModelChoiceGroup instance = (IBoundInstanceModelChoiceGroup)ObjectUtils.requireNonNull((Object)rootDefinition.getChoiceGroupInstanceByName("definitions"));
            for (Object obj : BindingModule.this.binding.getDefinitions()) {
                QName name;
                Object definition;
                assert (obj != null) : "Object was null";
                IBoundInstanceModelGroupedAssembly objInstance = (IBoundInstanceModelGroupedAssembly)instance.getItemInstance(obj);
                if (obj instanceof METASCHEMA.DefineAssembly) {
                    definition = new DefinitionAssemblyGlobal((METASCHEMA.DefineAssembly)obj, objInstance, globalAssemblyPosition++, BindingModule.this, nodeItemFactory);
                    name = definition.getDefinitionQName();
                    this.assemblyDefinitions.put(name, (IAssemblyDefinition)definition);
                    if (!definition.isRoot()) continue;
                    this.rootAssemblyDefinitions.put(name, (IAssemblyDefinition)definition);
                    continue;
                }
                if (obj instanceof METASCHEMA.DefineField) {
                    definition = new DefinitionFieldGlobal((METASCHEMA.DefineField)obj, objInstance, globalFieldPosition++, BindingModule.this);
                    name = definition.getDefinitionQName();
                    this.fieldDefinitions.put(name, (IFieldDefinition)definition);
                    continue;
                }
                if (obj instanceof METASCHEMA.DefineFlag) {
                    definition = new DefinitionFlagGlobal((METASCHEMA.DefineFlag)obj, objInstance, globalFlagPosition++, BindingModule.this);
                    name = definition.getDefinitionQName();
                    this.flagDefinitions.put(name, (IFlagDefinition)definition);
                    continue;
                }
                throw new IllegalStateException(String.format("Unrecognized definition class '%s' in module '%s'.", obj.getClass(), resource.toASCIIString()));
            }
        }
    }
}

