/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.metapath.item.node.INodeItemFactory;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IContainerModelSupport;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedModelInstanceGrouped;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceModelGroupedAssemblyInline;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceModelGroupedAssemblyReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceModelGroupedFieldInline;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceModelGroupedFieldReference;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

class ChoiceGroupModelContainerSupport
implements IContainerModelSupport<INamedModelInstanceGrouped, INamedModelInstanceGrouped, IFieldInstanceGrouped, IAssemblyInstanceGrouped> {
    @NonNull
    private final Map<QName, INamedModelInstanceGrouped> namedModelInstances;
    @NonNull
    private final Map<QName, IFieldInstanceGrouped> fieldInstances;
    @NonNull
    private final Map<QName, IAssemblyInstanceGrouped> assemblyInstances;

    public static IContainerModelSupport<INamedModelInstanceGrouped, INamedModelInstanceGrouped, IFieldInstanceGrouped, IAssemblyInstanceGrouped> of(@Nullable AssemblyModel.ChoiceGroup binding, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, @NonNull IChoiceGroupInstance parent, @NonNull INodeItemFactory nodeItemFactory) {
        List<Object> instances;
        return binding == null || (instances = binding.getChoices()) == null || instances.isEmpty() ? IContainerModelSupport.empty() : new ChoiceGroupModelContainerSupport(binding, bindingInstance, parent, nodeItemFactory);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    public ChoiceGroupModelContainerSupport(@NonNull AssemblyModel.ChoiceGroup binding, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, @NonNull IChoiceGroupInstance parent, @NonNull INodeItemFactory nodeItemFactory) {
        LinkedHashMap<QName, INamedModelInstanceGrouped> namedModelInstances = new LinkedHashMap<QName, INamedModelInstanceGrouped>();
        LinkedHashMap<QName, IFieldInstanceGrouped> fieldInstances = new LinkedHashMap<QName, IFieldInstanceGrouped>();
        LinkedHashMap<QName, IAssemblyInstanceGrouped> assemblyInstances = new LinkedHashMap<QName, IAssemblyInstanceGrouped>();
        int assemblyReferencePosition = 0;
        int assemblyInlineDefinitionPosition = 0;
        int fieldReferencePosition = 0;
        int fieldInlineDefinitionPosition = 0;
        IBoundInstanceModelChoiceGroup instance = (IBoundInstanceModelChoiceGroup)ObjectUtils.requireNonNull((Object)bindingInstance.getDefinition().getChoiceGroupInstanceByName("choices"));
        for (Object obj : (List)ObjectUtils.notNull(binding.getChoices())) {
            IFieldInstanceGrouped field;
            IAssemblyInstanceGrouped assembly;
            assert (obj != null);
            IBoundInstanceModelGroupedAssembly objInstance = (IBoundInstanceModelGroupedAssembly)instance.getItemInstance(obj);
            if (obj instanceof AssemblyModel.ChoiceGroup.Assembly) {
                assembly = ChoiceGroupModelContainerSupport.newInstance((AssemblyModel.ChoiceGroup.Assembly)obj, objInstance, assemblyReferencePosition++, parent);
                ChoiceGroupModelContainerSupport.addInstance(assembly, namedModelInstances, assemblyInstances);
                continue;
            }
            if (obj instanceof AssemblyModel.ChoiceGroup.DefineAssembly) {
                assembly = new InstanceModelGroupedAssemblyInline((AssemblyModel.ChoiceGroup.DefineAssembly)obj, objInstance, assemblyInlineDefinitionPosition++, parent, nodeItemFactory);
                ChoiceGroupModelContainerSupport.addInstance(assembly, namedModelInstances, assemblyInstances);
                continue;
            }
            if (obj instanceof AssemblyModel.ChoiceGroup.Field) {
                field = ChoiceGroupModelContainerSupport.newInstance((AssemblyModel.ChoiceGroup.Field)obj, objInstance, fieldReferencePosition++, parent);
                ChoiceGroupModelContainerSupport.addInstance(field, namedModelInstances, fieldInstances);
                continue;
            }
            if (obj instanceof AssemblyModel.ChoiceGroup.DefineField) {
                field = new InstanceModelGroupedFieldInline((AssemblyModel.ChoiceGroup.DefineField)obj, objInstance, fieldInlineDefinitionPosition++, parent);
                ChoiceGroupModelContainerSupport.addInstance(field, namedModelInstances, fieldInstances);
                continue;
            }
            throw new UnsupportedOperationException(String.format("Unknown choice group model instance class: %s", obj.getClass()));
        }
        this.namedModelInstances = namedModelInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(namedModelInstances);
        this.fieldInstances = fieldInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(fieldInstances);
        this.assemblyInstances = assemblyInstances.isEmpty() ? CollectionUtil.emptyMap() : CollectionUtil.unmodifiableMap(assemblyInstances);
    }

    protected static void addInstance(@NonNull IAssemblyInstanceGrouped assembly, @NonNull Map<QName, INamedModelInstanceGrouped> namedModelInstances, @NonNull Map<QName, IAssemblyInstanceGrouped> assemblyInstances) {
        QName effectiveName = assembly.getXmlQName();
        namedModelInstances.put(effectiveName, (INamedModelInstanceGrouped)assembly);
        assemblyInstances.put(effectiveName, assembly);
    }

    protected static void addInstance(@NonNull IFieldInstanceGrouped field, @NonNull Map<QName, INamedModelInstanceGrouped> namedModelInstances, @NonNull Map<QName, IFieldInstanceGrouped> fieldInstances) {
        QName effectiveName = field.getXmlQName();
        namedModelInstances.put(effectiveName, (INamedModelInstanceGrouped)field);
        fieldInstances.put(effectiveName, field);
    }

    @NonNull
    protected static IAssemblyInstanceGrouped newInstance(@NonNull AssemblyModel.ChoiceGroup.Assembly obj, @NonNull IBoundInstanceModelGroupedAssembly objInstance, int position, @NonNull IChoiceGroupInstance parent) {
        QName name;
        IAssemblyDefinition owningDefinition = parent.getOwningDefinition();
        IModule module = owningDefinition.getContainingModule();
        IAssemblyDefinition definition = module.getScopedAssemblyDefinitionByName(name = parent.getContainingModule().toModelQName((String)ObjectUtils.requireNonNull((Object)obj.getRef())));
        if (definition == null) {
            throw new IllegalStateException(String.format("Unable to resolve assembly reference '%s' in definition '%s' in module '%s'", name, owningDefinition.getName(), module.getShortName()));
        }
        return new InstanceModelGroupedAssemblyReference(obj, objInstance, position, definition, parent);
    }

    @NonNull
    protected static IFieldInstanceGrouped newInstance(@NonNull AssemblyModel.ChoiceGroup.Field obj, @NonNull IBoundInstanceModelGroupedAssembly objInstance, int position, @NonNull IChoiceGroupInstance parent) {
        QName name;
        IAssemblyDefinition owningDefinition = parent.getOwningDefinition();
        IModule module = owningDefinition.getContainingModule();
        IFieldDefinition definition = module.getScopedFieldDefinitionByName(name = parent.getContainingModule().toModelQName((String)ObjectUtils.requireNonNull((Object)obj.getRef())));
        if (definition == null) {
            throw new IllegalStateException(String.format("Unable to resolve field reference '%s' in definition '%s' in module '%s'", name, owningDefinition.getName(), module.getShortName()));
        }
        return new InstanceModelGroupedFieldReference(obj, objInstance, position, definition, parent);
    }

    public Collection<INamedModelInstanceGrouped> getModelInstances() {
        return this.namedModelInstances.values();
    }

    public Map<QName, INamedModelInstanceGrouped> getNamedModelInstanceMap() {
        return this.namedModelInstances;
    }

    public Map<QName, IFieldInstanceGrouped> getFieldInstanceMap() {
        return this.fieldInstances;
    }

    public Map<QName, IAssemblyInstanceGrouped> getAssemblyInstanceMap() {
        return this.assemblyInstances;
    }
}

