/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.model.ISource;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractConfigurableMessageConstraintBuilder;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractConstraintBuilder;
import gov.nist.secauto.metaschema.core.model.constraint.AbstractKeyConstraintBuilder;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.ICardinalityConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IExpectConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IIndexConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IKeyField;
import gov.nist.secauto.metaschema.core.model.constraint.ILet;
import gov.nist.secauto.metaschema.core.model.constraint.IMatchesConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IModelConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.IUniqueConstraint;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.metaschema.IConfigurableMessageConstraintBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.IConstraintBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.IModelConstraintsBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.IValueConstraintsBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.IValueTargetedConstraintsBase;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.ConstraintValueEnum;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FlagAllowedValues;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FlagExpect;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FlagIndexHasKey;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FlagMatches;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.KeyConstraintField;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Remarks;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedAllowedValuesConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedExpectConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedHasCardinalityConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedIndexConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedIndexHasKeyConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedIsUniqueConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.TargetedMatchesConstraint;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ModelSupport;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public final class ConstraintBindingSupport {
    private ConstraintBindingSupport() {
    }

    public static void parse(@NonNull IValueConstrained constraintSet, @NonNull IValueConstraintsBase constraints, @NonNull ISource source) {
        ConstraintBindingSupport.parseLet(constraintSet, constraints, source);
        for (IConstraintBase iConstraintBase : constraints.getRules()) {
            IAllowedValuesConstraint constraint;
            if (iConstraintBase instanceof FlagAllowedValues) {
                constraint = ConstraintBindingSupport.newAllowedValues((FlagAllowedValues)iConstraintBase, source);
                constraintSet.addConstraint(constraint);
                continue;
            }
            if (iConstraintBase instanceof FlagExpect) {
                constraint = ConstraintBindingSupport.newExpect((FlagExpect)iConstraintBase, source);
                constraintSet.addConstraint((IExpectConstraint)constraint);
                continue;
            }
            if (iConstraintBase instanceof FlagIndexHasKey) {
                constraint = ConstraintBindingSupport.newIndexHasKey((FlagIndexHasKey)iConstraintBase, source);
                constraintSet.addConstraint((IIndexHasKeyConstraint)constraint);
                continue;
            }
            if (!(iConstraintBase instanceof FlagMatches)) continue;
            constraint = ConstraintBindingSupport.newMatches((FlagMatches)iConstraintBase, source);
            constraintSet.addConstraint((IMatchesConstraint)constraint);
        }
    }

    public static void parse(@NonNull IValueConstrained constraintSet, @NonNull IValueTargetedConstraintsBase constraints, @NonNull ISource source) {
        ConstraintBindingSupport.parseLet(constraintSet, constraints, source);
        for (IConstraintBase iConstraintBase : constraints.getRules()) {
            IAllowedValuesConstraint constraint;
            if (iConstraintBase instanceof TargetedAllowedValuesConstraint) {
                constraint = ConstraintBindingSupport.newAllowedValues((TargetedAllowedValuesConstraint)iConstraintBase, source);
                constraintSet.addConstraint(constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedExpectConstraint) {
                constraint = ConstraintBindingSupport.newExpect((TargetedExpectConstraint)iConstraintBase, source);
                constraintSet.addConstraint((IExpectConstraint)constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedIndexHasKeyConstraint) {
                constraint = ConstraintBindingSupport.newIndexHasKey((TargetedIndexHasKeyConstraint)iConstraintBase, source);
                constraintSet.addConstraint((IIndexHasKeyConstraint)constraint);
                continue;
            }
            if (!(iConstraintBase instanceof TargetedMatchesConstraint)) continue;
            constraint = ConstraintBindingSupport.newMatches((TargetedMatchesConstraint)iConstraintBase, source);
            constraintSet.addConstraint((IMatchesConstraint)constraint);
        }
    }

    public static void parse(@NonNull IModelConstrained constraintSet, @NonNull IModelConstraintsBase constraints, @NonNull ISource source) {
        ConstraintBindingSupport.parseLet((IValueConstrained)constraintSet, constraints, source);
        for (IConstraintBase iConstraintBase : constraints.getRules()) {
            IAllowedValuesConstraint constraint;
            if (iConstraintBase instanceof TargetedAllowedValuesConstraint) {
                constraint = ConstraintBindingSupport.newAllowedValues((TargetedAllowedValuesConstraint)iConstraintBase, source);
                constraintSet.addConstraint(constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedExpectConstraint) {
                constraint = ConstraintBindingSupport.newExpect((TargetedExpectConstraint)iConstraintBase, source);
                constraintSet.addConstraint((IExpectConstraint)constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedIndexHasKeyConstraint) {
                constraint = ConstraintBindingSupport.newIndexHasKey((TargetedIndexHasKeyConstraint)iConstraintBase, source);
                constraintSet.addConstraint((IIndexHasKeyConstraint)constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedMatchesConstraint) {
                constraint = ConstraintBindingSupport.newMatches((TargetedMatchesConstraint)iConstraintBase, source);
                constraintSet.addConstraint((IMatchesConstraint)constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedIndexConstraint) {
                constraint = ConstraintBindingSupport.newIndex((TargetedIndexConstraint)iConstraintBase, source);
                constraintSet.addConstraint((IIndexConstraint)constraint);
                continue;
            }
            if (iConstraintBase instanceof TargetedHasCardinalityConstraint) {
                constraint = ConstraintBindingSupport.newHasCardinality((TargetedHasCardinalityConstraint)iConstraintBase, source);
                constraintSet.addConstraint((ICardinalityConstraint)constraint);
                continue;
            }
            if (!(iConstraintBase instanceof TargetedIsUniqueConstraint)) continue;
            constraint = ConstraintBindingSupport.newUnique((TargetedIsUniqueConstraint)iConstraintBase, source);
            constraintSet.addConstraint((IUniqueConstraint)constraint);
        }
    }

    public static void parseLet(@NonNull IValueConstrained constraintSet, @NonNull IValueConstraintsBase constraints, @NonNull ISource source) {
        constraints.getLets().stream().map(letObj -> {
            MarkupMultiline remarks = null;
            Remarks remarkObj = letObj.getRemarks();
            if (remarkObj != null) {
                remarks = remarkObj.getRemark();
            }
            return ILet.of((QName)((QName)ObjectUtils.requireNonNull((Object)new QName(letObj.getVar()))), (String)((String)ObjectUtils.requireNonNull((Object)letObj.getExpression())), (ISource)source, (MarkupMultiline)remarks);
        }).forEachOrdered(arg_0 -> ((IValueConstrained)constraintSet).addLetExpression(arg_0));
    }

    @NonNull
    private static IAllowedValuesConstraint newAllowedValues(@NonNull FlagAllowedValues obj, @NonNull ISource source) {
        IAllowedValuesConstraint.Builder builder = IAllowedValuesConstraint.builder().allowsOther(ModelSupport.yesOrNo(obj.getAllowOther())).extensible(ConstraintBindingSupport.extensible(obj.getExtensible()));
        ConstraintBindingSupport.applyCommonValues(obj, null, source, builder);
        for (ConstraintValueEnum value : (List)ObjectUtils.requireNonNull(obj.getEnums())) {
            builder.allowedValue((IAllowedValue)ObjectUtils.requireNonNull((Object)value));
        }
        return (IAllowedValuesConstraint)builder.build();
    }

    @NonNull
    private static IAllowedValuesConstraint newAllowedValues(@NonNull TargetedAllowedValuesConstraint obj, @NonNull ISource source) {
        IAllowedValuesConstraint.Builder builder = IAllowedValuesConstraint.builder().allowsOther(ModelSupport.yesOrNo(obj.getAllowOther())).extensible(ConstraintBindingSupport.extensible((String)ObjectUtils.requireNonNull((Object)obj.getExtensible())));
        ConstraintBindingSupport.applyCommonValues(obj, obj.getTarget(), source, builder);
        for (ConstraintValueEnum value : (List)ObjectUtils.requireNonNull(obj.getEnums())) {
            builder.allowedValue((IAllowedValue)ObjectUtils.requireNonNull((Object)value));
        }
        return (IAllowedValuesConstraint)builder.build();
    }

    @NonNull
    private static IExpectConstraint newExpect(@NonNull FlagExpect obj, @NonNull ISource source) {
        IExpectConstraint.Builder builder = IExpectConstraint.builder().test(ConstraintBindingSupport.target((String)ObjectUtils.requireNonNull((Object)obj.getTest())));
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, null, source, builder);
        String message = obj.getMessage();
        if (message != null) {
            builder.message(message);
        }
        return (IExpectConstraint)builder.build();
    }

    @NonNull
    private static IExpectConstraint newExpect(@NonNull TargetedExpectConstraint obj, @NonNull ISource source) {
        IExpectConstraint.Builder builder = IExpectConstraint.builder().test(ConstraintBindingSupport.target((String)ObjectUtils.requireNonNull((Object)obj.getTest())));
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, obj.getTarget(), source, builder);
        return (IExpectConstraint)builder.build();
    }

    @NonNull
    private static <T extends AbstractKeyConstraintBuilder<T, ?>> T handleKeyConstraints(@NonNull List<KeyConstraintField> keys, @NonNull T builder, @NonNull ISource source) {
        for (KeyConstraintField value : keys) {
            assert (value != null);
            IKeyField keyField = IKeyField.of((String)ConstraintBindingSupport.target((String)ObjectUtils.requireNonNull((Object)value.getTarget())), (Pattern)ConstraintBindingSupport.pattern(value.getPattern()), (MarkupMultiline)ModelSupport.remarks(value.getRemarks()), (ISource)source);
            builder.keyField(keyField);
        }
        return builder;
    }

    @NonNull
    private static IIndexHasKeyConstraint newIndexHasKey(@NonNull FlagIndexHasKey obj, @NonNull ISource source) {
        IIndexHasKeyConstraint.Builder builder = IIndexHasKeyConstraint.builder((String)((String)ObjectUtils.requireNonNull((Object)obj.getName())));
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, null, source, builder);
        ConstraintBindingSupport.handleKeyConstraints((List)ObjectUtils.requireNonNull(obj.getKeyFields()), builder, source);
        return (IIndexHasKeyConstraint)builder.build();
    }

    @NonNull
    private static IIndexHasKeyConstraint newIndexHasKey(@NonNull TargetedIndexHasKeyConstraint obj, @NonNull ISource source) {
        IIndexHasKeyConstraint.Builder builder = IIndexHasKeyConstraint.builder((String)((String)ObjectUtils.requireNonNull((Object)obj.getName())));
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, obj.getTarget(), source, builder);
        ConstraintBindingSupport.handleKeyConstraints((List)ObjectUtils.requireNonNull(obj.getKeyFields()), builder, source);
        return (IIndexHasKeyConstraint)builder.build();
    }

    @NonNull
    private static IMatchesConstraint newMatches(@NonNull FlagMatches obj, @NonNull ISource source) {
        String dataType;
        IMatchesConstraint.Builder builder = IMatchesConstraint.builder();
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, null, source, builder);
        Pattern regex = ConstraintBindingSupport.pattern(obj.getRegex());
        if (regex != null) {
            builder.regex(regex);
        }
        if ((dataType = obj.getDatatype()) != null) {
            IDataTypeAdapter<?> javaTypeAdapter = ModelSupport.dataType(obj.getDatatype());
            builder.datatype(javaTypeAdapter);
        }
        return (IMatchesConstraint)builder.build();
    }

    @NonNull
    private static IMatchesConstraint newMatches(@NonNull TargetedMatchesConstraint obj, @NonNull ISource source) {
        String dataType;
        IMatchesConstraint.Builder builder = IMatchesConstraint.builder();
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, obj.getTarget(), source, builder);
        Pattern regex = ConstraintBindingSupport.pattern(obj.getRegex());
        if (regex != null) {
            builder.regex(regex);
        }
        if ((dataType = obj.getDatatype()) != null) {
            IDataTypeAdapter<?> javaTypeAdapter = ModelSupport.dataType(obj.getDatatype());
            builder.datatype(javaTypeAdapter);
        }
        return (IMatchesConstraint)builder.build();
    }

    @NonNull
    private static IIndexConstraint newIndex(@NonNull TargetedIndexConstraint obj, @NonNull ISource source) {
        IIndexConstraint.Builder builder = IIndexConstraint.builder((String)((String)ObjectUtils.requireNonNull((Object)obj.getName())));
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, obj.getTarget(), source, builder);
        ConstraintBindingSupport.handleKeyConstraints((List)ObjectUtils.requireNonNull(obj.getKeyFields()), builder, source);
        return (IIndexConstraint)builder.build();
    }

    @NonNull
    private static ICardinalityConstraint newHasCardinality(@NonNull TargetedHasCardinalityConstraint obj, @NonNull ISource source) {
        String maxOccurs;
        ICardinalityConstraint.Builder builder = ICardinalityConstraint.builder();
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, obj.getTarget(), source, builder);
        BigInteger minOccurs = obj.getMinOccurs();
        if (minOccurs != null) {
            builder.minOccurs(minOccurs.intValueExact());
        }
        if ((maxOccurs = obj.getMaxOccurs()) != null) {
            int occurance = ModelSupport.maxOccurs(maxOccurs);
            builder.maxOccurs(occurance);
        }
        return (ICardinalityConstraint)builder.build();
    }

    @NonNull
    private static IUniqueConstraint newUnique(@NonNull TargetedIsUniqueConstraint obj, @NonNull ISource source) {
        IUniqueConstraint.Builder builder = IUniqueConstraint.builder();
        ConstraintBindingSupport.applyConfigurableCommonValues(obj, obj.getTarget(), source, builder);
        ConstraintBindingSupport.handleKeyConstraints((List)ObjectUtils.requireNonNull(obj.getKeyFields()), builder, source);
        return (IUniqueConstraint)builder.build();
    }

    @NonNull
    private static <T extends AbstractConfigurableMessageConstraintBuilder<T, ?>> T applyConfigurableCommonValues(@NonNull IConfigurableMessageConstraintBase constraint, @Nullable String target, @NonNull ISource source, @NonNull T builder) {
        ConstraintBindingSupport.applyCommonValues(constraint, target, source, builder);
        String message = constraint.getMessage();
        if (message != null) {
            builder.message(message);
        }
        return builder;
    }

    @NonNull
    private static <T extends AbstractConstraintBuilder<T, ?>> T applyCommonValues(@NonNull IConstraintBase constraint, @Nullable String target, @NonNull ISource source, @NonNull T builder) {
        MarkupLine description;
        String formalName;
        String id = constraint.getId();
        if (id != null) {
            builder.identifier(id);
        }
        if ((formalName = constraint.getFormalName()) != null) {
            builder.formalName(formalName);
        }
        if ((description = constraint.getDescription()) != null) {
            builder.description(description);
        }
        List props = (List)ObjectUtils.requireNonNull(constraint.getProps());
        builder.properties(ModelSupport.parseProperties(props));
        Remarks remarks = constraint.getRemarks();
        if (remarks != null) {
            builder.remarks((MarkupMultiline)ObjectUtils.notNull((Object)remarks.getRemark()));
        }
        builder.target(ConstraintBindingSupport.target(target));
        builder.level(ConstraintBindingSupport.level(constraint.getLevel()));
        builder.source(source);
        return builder;
    }

    @NonNull
    private static String target(@Nullable String target) {
        return target == null ? "." : target;
    }

    @NonNull
    private static IConstraint.Level level(@Nullable String level) {
        IConstraint.Level retval = IConstraint.DEFAULT_LEVEL;
        if (level != null) {
            switch (level) {
                case "CRITICAL": {
                    retval = IConstraint.Level.CRITICAL;
                    break;
                }
                case "ERROR": {
                    retval = IConstraint.Level.ERROR;
                    break;
                }
                case "WARNING": {
                    retval = IConstraint.Level.WARNING;
                    break;
                }
                case "INFORMATIONAL": {
                    retval = IConstraint.Level.INFORMATIONAL;
                    break;
                }
                case "DEBUG": {
                    retval = IConstraint.Level.DEBUG;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(level);
                }
            }
        }
        return retval;
    }

    @NonNull
    private static IAllowedValuesConstraint.Extensible extensible(@Nullable String extensible) {
        IAllowedValuesConstraint.Extensible retval = IAllowedValuesConstraint.EXTENSIBLE_DEFAULT;
        if (extensible != null) {
            switch (extensible) {
                case "model": {
                    retval = IAllowedValuesConstraint.Extensible.MODEL;
                    break;
                }
                case "external": {
                    retval = IAllowedValuesConstraint.Extensible.EXTERNAL;
                    break;
                }
                case "none": {
                    retval = IAllowedValuesConstraint.Extensible.NONE;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(extensible);
                }
            }
        }
        return retval;
    }

    @Nullable
    private static Pattern pattern(@Nullable String pattern) {
        return pattern == null ? null : Pattern.compile(pattern);
    }
}

