/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.model.AbstractGlobalFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IContainerFlagSupport;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstance;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.ValueConstraintSet;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FieldConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.JsonKey;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.JsonValueKeyFlag;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.METASCHEMA;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ConstraintBindingSupport;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.FlagContainerSupport;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ModelSupport;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.talsmasoftware.lazy4j.Lazy;

public class DefinitionFieldGlobal
extends AbstractGlobalFieldDefinition<IBindingMetaschemaModule, IFieldInstance, IFlagInstance>
implements IBindingDefinitionModel {
    @NonNull
    private final METASCHEMA.DefineField binding;
    @NonNull
    private final Map<IAttributable.Key, Set<String>> properties;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    @NonNull
    private final Lazy<IContainerFlagSupport<IFlagInstance>> flagContainer;
    @NonNull
    private final Lazy<IValueConstrained> valueConstraints;
    @NonNull
    private final Lazy<IAssemblyNodeItem> boundNodeItem;

    public DefinitionFieldGlobal(@NonNull METASCHEMA.DefineField binding, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, int position, @NonNull IBindingMetaschemaModule module) {
        super((IModule)module);
        this.binding = binding;
        this.properties = ModelSupport.parseProperties((List)ObjectUtils.requireNonNull(binding.getProps()));
        this.javaTypeAdapter = ModelSupport.dataType(binding.getAsType());
        this.defaultValue = ModelSupport.defaultValue(binding.getDefault(), this.javaTypeAdapter);
        this.flagContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            JsonKey jsonKey = binding.getJsonKey();
            return FlagContainerSupport.newFlagContainer(binding.getFlags(), bindingInstance, this, jsonKey == null ? null : jsonKey.getFlagRef());
        }));
        this.valueConstraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            ValueConstraintSet retval = new ValueConstraintSet();
            FieldConstraints constraints = binding.getConstraint();
            if (constraints != null) {
                ConstraintBindingSupport.parse((IValueConstrained)retval, constraints, module.getSource());
            }
            return retval;
        }));
        this.boundNodeItem = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> (IAssemblyNodeItem)ObjectUtils.requireNonNull(ModelSupport.toNodeItem(module, bindingInstance.getXmlQName(), position))));
    }

    @NonNull
    protected METASCHEMA.DefineField getBinding() {
        return this.binding;
    }

    public IContainerFlagSupport<IFlagInstance> getFlagContainer() {
        return (IContainerFlagSupport)ObjectUtils.notNull((Object)((IContainerFlagSupport)this.flagContainer.get()));
    }

    public IValueConstrained getConstraintSupport() {
        return (IValueConstrained)ObjectUtils.notNull((Object)((IValueConstrained)this.valueConstraints.get()));
    }

    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return this.properties;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public IAssemblyNodeItem getSourceNodeItem() {
        return (IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)this.boundNodeItem.get()));
    }

    public String getFormalName() {
        return this.getBinding().getFormalName();
    }

    public MarkupLine getDescription() {
        return this.getBinding().getDescription();
    }

    public String getName() {
        return (String)ObjectUtils.notNull((Object)this.getBinding().getName());
    }

    public IDefinition.ModuleScope getModuleScope() {
        return ModelSupport.moduleScope((String)ObjectUtils.requireNonNull((Object)this.getBinding().getScope()));
    }

    public Integer getIndex() {
        return ModelSupport.index(this.getBinding().getIndex());
    }

    public String getUseName() {
        return ModelSupport.useName(this.getBinding().getUseName());
    }

    public Integer getUseIndex() {
        return ModelSupport.useIndex(this.getBinding().getUseName());
    }

    public MarkupMultiline getRemarks() {
        return ModelSupport.remarks(this.getBinding().getRemarks());
    }

    public IFlagInstance getJsonValueKeyFlagInstance() {
        JsonValueKeyFlag obj = this.getBinding().getJsonValueKeyFlag();
        String name = obj == null ? null : obj.getFlagRef();
        return name == null ? null : (IFlagInstance)ObjectUtils.requireNonNull((Object)this.getFlagInstanceByName(((IBindingMetaschemaModule)this.getContainingModule()).toFlagQName(name)));
    }

    public String getJsonValueKeyName() {
        return this.getBinding().getJsonValueKey();
    }
}

