/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.model.IContainerFlagSupport;
import gov.nist.secauto.metaschema.core.model.IFlagContainerBuilder;
import gov.nist.secauto.metaschema.core.model.IFlagDefinition;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelChoiceGroup;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FlagReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.InlineDefineFlag;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceFlagInline;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.InstanceFlagReference;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;

public final class FlagContainerSupport {
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Use of final fields")
    @NonNull
    public static IContainerFlagSupport<IFlagInstance> newFlagContainer(@Nullable List<Object> flags, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, @NonNull IBindingDefinitionModel parent, @Nullable String jsonKeyName) {
        if (flags == null || flags.isEmpty()) {
            return IContainerFlagSupport.empty();
        }
        IFlagContainerBuilder builder = jsonKeyName == null ? IContainerFlagSupport.builder() : IContainerFlagSupport.builder((QName)parent.getContainingModule().toFlagQName(jsonKeyName));
        AtomicInteger flagReferencePosition = new AtomicInteger();
        AtomicInteger flagInlineDefinitionPosition = new AtomicInteger();
        IBoundInstanceModelChoiceGroup instance = (IBoundInstanceModelChoiceGroup)ObjectUtils.requireNonNull((Object)bindingInstance.getDefinition().getChoiceGroupInstanceByName("flags"));
        flags.stream().map(obj -> {
            InstanceFlagInline flag;
            assert (obj != null);
            IBoundInstanceModelGroupedAssembly objInstance = (IBoundInstanceModelGroupedAssembly)instance.getItemInstance(obj);
            if (obj instanceof InlineDefineFlag) {
                flag = new InstanceFlagInline((InlineDefineFlag)obj, objInstance, flagInlineDefinitionPosition.incrementAndGet(), parent);
            } else if (obj instanceof FlagReference) {
                flag = FlagContainerSupport.newFlagInstance((FlagReference)obj, objInstance, flagReferencePosition.incrementAndGet(), parent);
            } else {
                throw new UnsupportedOperationException(String.format("Unknown flag instance class: %s", obj.getClass()));
            }
            return flag;
        }).forEachOrdered(arg_0 -> ((IFlagContainerBuilder)builder).flag(arg_0));
        return builder.build();
    }

    @NonNull
    private static IFlagInstance newFlagInstance(@NonNull FlagReference obj, @NonNull IBoundInstanceModelGroupedAssembly objInstance, int position, @NonNull IBindingDefinitionModel parent) {
        QName qname;
        IBindingMetaschemaModule module = parent.getContainingModule();
        IFlagDefinition definition = module.getScopedFlagDefinitionByName(qname = module.toFlagQName((String)ObjectUtils.requireNonNull((Object)obj.getRef())));
        if (definition == null) {
            throw new IllegalStateException(String.format("Unable to resolve flag reference '%s' in definition '%s' in module '%s'", qname, parent.getName(), module.getShortName()));
        }
        return new InstanceFlagReference(obj, objInstance, position, definition, parent);
    }

    private FlagContainerSupport() {
    }
}

