/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.model.AbstractAssemblyInstance;
import gov.nist.secauto.metaschema.core.model.IAssemblyDefinition;
import gov.nist.secauto.metaschema.core.model.IAssemblyInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IContainerModel;
import gov.nist.secauto.metaschema.core.model.IContainerModelAbsolute;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingInstance;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyReference;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ModelSupport;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.talsmasoftware.lazy4j.Lazy;

public class InstanceModelAssemblyReference
extends AbstractAssemblyInstance<IContainerModelAbsolute, IAssemblyDefinition, IAssemblyInstanceAbsolute, IBindingDefinitionModelAssembly>
implements IAssemblyInstanceAbsolute,
IBindingInstance,
IFeatureInstanceModelGroupAs {
    @NonNull
    private final AssemblyReference binding;
    @NonNull
    private final IAssemblyDefinition definition;
    @NonNull
    private final Map<IAttributable.Key, Set<String>> properties;
    @NonNull
    private final IGroupAs groupAs;
    @NonNull
    private final Lazy<IAssemblyNodeItem> boundNodeItem;

    public InstanceModelAssemblyReference(@NonNull AssemblyReference binding, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, int position, @NonNull IAssemblyDefinition definition, @NonNull IContainerModelAbsolute parent) {
        super((IContainerModel)parent);
        this.binding = binding;
        this.definition = definition;
        this.properties = ModelSupport.parseProperties((List)ObjectUtils.requireNonNull(binding.getProps()));
        this.groupAs = ModelSupport.groupAs(binding.getGroupAs(), parent.getOwningDefinition().getContainingModule());
        this.boundNodeItem = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> (IAssemblyNodeItem)((IDocumentNodeItem)ObjectUtils.notNull((Object)this.getContainingModule().getSourceNodeItem())).getModelItemsByName(bindingInstance.getXmlQName()).get(position)));
    }

    public IAssemblyDefinition getDefinition() {
        return this.definition;
    }

    @NonNull
    protected AssemblyReference getBinding() {
        return this.binding;
    }

    @Override
    public IBindingMetaschemaModule getContainingModule() {
        return ((IBindingDefinitionModelAssembly)this.getContainingDefinition()).getContainingModule();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return this.properties;
    }

    @Override
    public IGroupAs getGroupAs() {
        return this.groupAs;
    }

    @Override
    public IAssemblyNodeItem getSourceNodeItem() {
        return (IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)this.boundNodeItem.get()));
    }

    public String getName() {
        return this.getDefinition().getName();
    }

    public Integer getIndex() {
        return ModelSupport.index(this.getBinding().getIndex());
    }

    public String getUseName() {
        return ModelSupport.useName(this.getBinding().getUseName());
    }

    public Integer getUseIndex() {
        return ModelSupport.useIndex(this.getBinding().getUseName());
    }

    public String getFormalName() {
        return this.getBinding().getFormalName();
    }

    public MarkupLine getDescription() {
        return this.getBinding().getDescription();
    }

    public MarkupMultiline getRemarks() {
        return ModelSupport.remarks(this.getBinding().getRemarks());
    }

    public int getMinOccurs() {
        BigInteger min = this.getBinding().getMinOccurs();
        return min == null ? 0 : min.intValueExact();
    }

    public int getMaxOccurs() {
        String max = this.getBinding().getMaxOccurs();
        return max == null ? 1 : ModelSupport.maxOccurs(max);
    }
}

