/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.model.AbstractInlineFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IContainerFlagSupport;
import gov.nist.secauto.metaschema.core.model.IContainerModel;
import gov.nist.secauto.metaschema.core.model.IContainerModelAbsolute;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceAbsolute;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.ValueConstraintSet;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingInstance;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FieldConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.InlineDefineField;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.JsonKey;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.JsonValueKeyFlag;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ConstraintBindingSupport;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.FlagContainerSupport;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.IFeatureInstanceModelGroupAs;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ModelSupport;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public class InstanceModelFieldInline
extends AbstractInlineFieldDefinition<IContainerModelAbsolute, IFieldDefinition, IFieldInstanceAbsolute, IBindingDefinitionModelAssembly, IFlagInstance>
implements IFieldInstanceAbsolute,
IBindingInstance,
IBindingDefinitionModel,
IFeatureInstanceModelGroupAs {
    @NonNull
    private final InlineDefineField binding;
    @NonNull
    private final Map<IAttributable.Key, Set<String>> properties;
    @NonNull
    private final IGroupAs groupAs;
    @NonNull
    private final Lazy<IAssemblyNodeItem> boundNodeItem;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    @NonNull
    private final Lazy<IContainerFlagSupport<IFlagInstance>> flagContainer;
    @NonNull
    private final Lazy<IValueConstrained> valueConstraints;

    public InstanceModelFieldInline(@NonNull InlineDefineField binding, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, int position, @NonNull IContainerModelAbsolute parent) {
        super((IContainerModel)parent);
        this.binding = binding;
        this.properties = ModelSupport.parseProperties((List)ObjectUtils.requireNonNull(binding.getProps()));
        this.groupAs = ModelSupport.groupAs(binding.getGroupAs(), parent.getOwningDefinition().getContainingModule());
        this.boundNodeItem = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> (IAssemblyNodeItem)((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IBindingDefinitionModelAssembly)this.getContainingDefinition()).getSourceNodeItem())).getModelItemsByName(bindingInstance.getXmlQName()).get(position)));
        this.javaTypeAdapter = ModelSupport.dataType(binding.getAsType());
        this.defaultValue = ModelSupport.defaultValue(binding.getDefault(), this.javaTypeAdapter);
        this.flagContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            JsonKey jsonKey = binding.getJsonKey();
            return FlagContainerSupport.newFlagContainer(binding.getFlags(), bindingInstance, this, jsonKey == null ? null : jsonKey.getFlagRef());
        }));
        this.valueConstraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            ValueConstraintSet retval = new ValueConstraintSet();
            FieldConstraints constraints = binding.getConstraint();
            if (constraints != null) {
                ConstraintBindingSupport.parse((IValueConstrained)retval, constraints, parent.getOwningDefinition().getContainingModule().getSource());
            }
            return retval;
        }));
    }

    @NonNull
    private InlineDefineField getBinding() {
        return this.binding;
    }

    @Override
    public IBindingMetaschemaModule getContainingModule() {
        return ((IBindingDefinitionModelAssembly)this.getContainingDefinition()).getContainingModule();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return this.properties;
    }

    @Override
    public IGroupAs getGroupAs() {
        return this.groupAs;
    }

    public IContainerFlagSupport<IFlagInstance> getFlagContainer() {
        return (IContainerFlagSupport)ObjectUtils.notNull((Object)((IContainerFlagSupport)this.flagContainer.get()));
    }

    public IValueConstrained getConstraintSupport() {
        return (IValueConstrained)ObjectUtils.notNull((Object)((IValueConstrained)this.valueConstraints.get()));
    }

    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public IAssemblyNodeItem getSourceNodeItem() {
        return (IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)this.boundNodeItem.get()));
    }

    public boolean isInXmlWrapped() {
        return ModelSupport.fieldInXml(this.getBinding().getInXml());
    }

    public String getName() {
        return (String)ObjectUtils.notNull((Object)this.getBinding().getName());
    }

    public Integer getIndex() {
        return ModelSupport.index(this.getBinding().getIndex());
    }

    public String getFormalName() {
        return this.getBinding().getFormalName();
    }

    public MarkupLine getDescription() {
        return this.getBinding().getDescription();
    }

    public MarkupMultiline getRemarks() {
        return ModelSupport.remarks(this.getBinding().getRemarks());
    }

    public int getMinOccurs() {
        BigInteger min = this.getBinding().getMinOccurs();
        return min == null ? 0 : min.intValueExact();
    }

    public int getMaxOccurs() {
        String max = this.getBinding().getMaxOccurs();
        return max == null ? 1 : ModelSupport.maxOccurs(max);
    }

    public IFlagInstance getJsonValueKeyFlagInstance() {
        JsonValueKeyFlag obj = this.getBinding().getJsonValueKeyFlag();
        String name = obj == null ? null : obj.getFlagRef();
        String namespace = this.getContainingModule().getXmlNamespace().toASCIIString();
        return name == null ? null : (IFlagInstance)ObjectUtils.requireNonNull((Object)this.getFlagInstanceByName(new QName(namespace, name)));
    }

    public String getJsonValueKeyName() {
        return this.getBinding().getJsonValueKey();
    }
}

