/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupLine;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.model.AbstractInlineFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IChoiceGroupInstance;
import gov.nist.secauto.metaschema.core.model.IContainerFlagSupport;
import gov.nist.secauto.metaschema.core.model.IContainerModel;
import gov.nist.secauto.metaschema.core.model.IFieldDefinition;
import gov.nist.secauto.metaschema.core.model.IFieldInstanceGrouped;
import gov.nist.secauto.metaschema.core.model.IFlagInstance;
import gov.nist.secauto.metaschema.core.model.constraint.IValueConstrained;
import gov.nist.secauto.metaschema.core.model.constraint.ValueConstraintSet;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IBoundInstanceModelGroupedAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingDefinitionModelAssembly;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingInstance;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.AssemblyModel;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.FieldConstraints;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.JsonValueKeyFlag;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ConstraintBindingSupport;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.FlagContainerSupport;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.ModelSupport;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import nl.talsmasoftware.lazy4j.Lazy;

public class InstanceModelGroupedFieldInline
extends AbstractInlineFieldDefinition<IChoiceGroupInstance, IFieldDefinition, IFieldInstanceGrouped, IBindingDefinitionModelAssembly, IFlagInstance>
implements IFieldInstanceGrouped,
IBindingInstance,
IBindingDefinitionModel {
    @NonNull
    private final AssemblyModel.ChoiceGroup.DefineField binding;
    @NonNull
    private final Map<IAttributable.Key, Set<String>> properties;
    @NonNull
    private final IDataTypeAdapter<?> javaTypeAdapter;
    @Nullable
    private final Object defaultValue;
    @NonNull
    private final Lazy<IContainerFlagSupport<IFlagInstance>> flagContainer;
    @NonNull
    private final Lazy<IValueConstrained> valueConstraints;
    @NonNull
    private final Lazy<IAssemblyNodeItem> boundNodeItem;

    public InstanceModelGroupedFieldInline(@NonNull AssemblyModel.ChoiceGroup.DefineField binding, @NonNull IBoundInstanceModelGroupedAssembly bindingInstance, int position, @NonNull IChoiceGroupInstance parent) {
        super((IContainerModel)parent);
        this.binding = binding;
        this.properties = ModelSupport.parseProperties((List)ObjectUtils.requireNonNull(binding.getProps()));
        this.javaTypeAdapter = ModelSupport.dataType(binding.getAsType());
        this.defaultValue = ModelSupport.defaultValue(binding.getDefault(), this.javaTypeAdapter);
        this.flagContainer = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> FlagContainerSupport.newFlagContainer(binding.getFlags(), bindingInstance, this, ((IChoiceGroupInstance)this.getParentContainer()).getJsonKeyFlagInstanceName())));
        this.valueConstraints = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> {
            ValueConstraintSet retval = new ValueConstraintSet();
            FieldConstraints constraints = binding.getConstraint();
            if (constraints != null) {
                ConstraintBindingSupport.parse((IValueConstrained)retval, constraints, parent.getOwningDefinition().getContainingModule().getSource());
            }
            return retval;
        }));
        this.boundNodeItem = (Lazy)ObjectUtils.notNull((Object)Lazy.lazy(() -> (IAssemblyNodeItem)((IAssemblyNodeItem)ObjectUtils.notNull((Object)((IBindingDefinitionModelAssembly)this.getContainingDefinition()).getSourceNodeItem())).getModelItemsByName(bindingInstance.getXmlQName()).get(position)));
    }

    @NonNull
    private AssemblyModel.ChoiceGroup.DefineField getBinding() {
        return this.binding;
    }

    @Override
    public IBindingMetaschemaModule getContainingModule() {
        return ((IBindingDefinitionModelAssembly)this.getContainingDefinition()).getContainingModule();
    }

    public Map<IAttributable.Key, Set<String>> getProperties() {
        return this.properties;
    }

    public IContainerFlagSupport<IFlagInstance> getFlagContainer() {
        return (IContainerFlagSupport)ObjectUtils.notNull((Object)((IContainerFlagSupport)this.flagContainer.get()));
    }

    public IValueConstrained getConstraintSupport() {
        return (IValueConstrained)ObjectUtils.notNull((Object)((IValueConstrained)this.valueConstraints.get()));
    }

    @Override
    public IAssemblyNodeItem getSourceNodeItem() {
        return (IAssemblyNodeItem)ObjectUtils.notNull((Object)((IAssemblyNodeItem)this.boundNodeItem.get()));
    }

    public IDataTypeAdapter<?> getJavaTypeAdapter() {
        return this.javaTypeAdapter;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return (String)ObjectUtils.notNull((Object)this.getBinding().getName());
    }

    public Integer getIndex() {
        return ModelSupport.index(this.getBinding().getIndex());
    }

    public String getFormalName() {
        return this.getBinding().getFormalName();
    }

    public MarkupLine getDescription() {
        return this.getBinding().getDescription();
    }

    public MarkupMultiline getRemarks() {
        return ModelSupport.remarks(this.getBinding().getRemarks());
    }

    public String getDiscriminatorValue() {
        return this.getBinding().getDiscriminatorValue();
    }

    public IFlagInstance getJsonValueKeyFlagInstance() {
        JsonValueKeyFlag obj = this.getBinding().getJsonValueKeyFlag();
        String flagName = obj == null ? null : obj.getFlagRef();
        return flagName == null ? null : this.getFlagInstanceByName(new QName(this.getXmlNamespace(), flagName));
    }

    public String getJsonValueKeyName() {
        return this.getBinding().getJsonValueKey();
    }
}

