/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.databind.model.metaschema.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.datatype.DataTypeService;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.core.datatype.adapter.MetaschemaDataTypeProvider;
import gov.nist.secauto.metaschema.core.datatype.adapter.StringAdapter;
import gov.nist.secauto.metaschema.core.datatype.markup.MarkupMultiline;
import gov.nist.secauto.metaschema.core.metapath.item.node.IAssemblyNodeItem;
import gov.nist.secauto.metaschema.core.metapath.item.node.IDocumentNodeItem;
import gov.nist.secauto.metaschema.core.model.IAttributable;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IGroupable;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.JsonGroupAsBehavior;
import gov.nist.secauto.metaschema.core.model.XmlGroupAsBehavior;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.model.IGroupAs;
import gov.nist.secauto.metaschema.databind.model.annotations.ModelUtil;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.GroupingAs;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.METASCHEMA;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Property;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.Remarks;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.UseName;
import gov.nist.secauto.metaschema.databind.model.metaschema.impl.GroupAsImpl;
import java.math.BigInteger;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;

public final class ModelSupport {
    private ModelSupport() {
    }

    @NonNull
    public static Map<IAttributable.Key, Set<String>> parseProperties(@NonNull List<Property> props) {
        return CollectionUtil.unmodifiableMap((Map)((Map)ObjectUtils.notNull(props.stream().collect(Collectors.groupingBy(prop -> {
            String name = (String)ObjectUtils.requireNonNull((Object)prop.getName());
            URI namespace = prop.getNamespace();
            return namespace == null ? IAttributable.key((String)name) : IAttributable.key((String)name, (String)((String)ObjectUtils.notNull((Object)namespace.toASCIIString())));
        }, Collectors.mapping(prop -> (String)ObjectUtils.requireNonNull((Object)prop.getValue()), Collectors.toCollection(LinkedHashSet::new)))))));
    }

    public static boolean yesOrNo(String allowOther) {
        return "yes".equals(allowOther);
    }

    @NonNull
    public static IDefinition.ModuleScope moduleScope(@NonNull String value) {
        IDefinition.ModuleScope retval;
        switch (value) {
            case "local": {
                retval = IDefinition.ModuleScope.PRIVATE;
                break;
            }
            default: {
                retval = IDefinition.ModuleScope.PUBLIC;
            }
        }
        return retval;
    }

    @Nullable
    public static Integer index(@Nullable BigInteger index) {
        return index == null ? null : Integer.valueOf(index.intValueExact());
    }

    @Nullable
    public static String useName(@Nullable UseName useName) {
        return useName == null ? null : useName.getName();
    }

    @Nullable
    public static Integer useIndex(@Nullable UseName useName) {
        BigInteger index;
        Integer retval = null;
        if (useName != null && (index = useName.getIndex()) != null) {
            retval = index.intValueExact();
        }
        return retval;
    }

    @Nullable
    public static MarkupMultiline remarks(@Nullable Remarks remarks) {
        return remarks == null ? null : remarks.getRemark();
    }

    @NonNull
    public static IDataTypeAdapter<?> dataType(@Nullable String dataType) {
        StringAdapter retval;
        if (dataType == null) {
            retval = MetaschemaDataTypeProvider.DEFAULT_DATA_TYPE;
        } else {
            retval = DataTypeService.getInstance().getJavaTypeAdapterByName(dataType);
            if (retval == null) {
                throw new IllegalStateException("Unrecognized data type: " + dataType);
            }
        }
        return retval;
    }

    @Nullable
    public static Object defaultValue(@Nullable String defaultValue, @NonNull IDataTypeAdapter<?> javaTypeAdapter) {
        return defaultValue == null ? null : ModelUtil.resolveDefaultValue(defaultValue, javaTypeAdapter);
    }

    public static int maxOccurs(@NonNull String maxOccurs) {
        return "unbounded".equals(maxOccurs) ? -1 : Integer.parseInt(maxOccurs);
    }

    public static String rootName(@Nullable METASCHEMA.DefineAssembly.RootName rootName) {
        return rootName == null ? null : rootName.getName();
    }

    public static Integer rootIndex(@Nullable METASCHEMA.DefineAssembly.RootName rootName) {
        BigInteger index;
        Integer retval = null;
        if (rootName != null && (index = rootName.getIndex()) != null) {
            retval = index.intValueExact();
        }
        return retval;
    }

    public static boolean fieldInXml(@Nullable String inXml) {
        boolean retval = true;
        if (inXml != null) {
            switch (inXml) {
                case "WRAPPED": 
                case "WITH_WRAPPER": {
                    retval = true;
                    break;
                }
                default: {
                    retval = false;
                }
            }
        }
        return retval;
    }

    @NonNull
    public static IGroupAs groupAs(@Nullable GroupingAs groupAs, @NonNull IModule module) {
        return groupAs == null ? IGroupAs.SINGLETON_GROUP_AS : new GroupAsImpl(groupAs, module);
    }

    @NonNull
    public static JsonGroupAsBehavior groupAsJsonBehavior(@Nullable String inJson) {
        JsonGroupAsBehavior retval = IGroupable.DEFAULT_JSON_GROUP_AS_BEHAVIOR;
        if (inJson != null) {
            switch (inJson) {
                case "ARRAY": {
                    retval = JsonGroupAsBehavior.LIST;
                    break;
                }
                case "SINGLETON_OR_ARRAY": {
                    retval = JsonGroupAsBehavior.SINGLETON_OR_LIST;
                    break;
                }
                case "BY_KEY": {
                    retval = JsonGroupAsBehavior.KEYED;
                    break;
                }
                default: {
                    retval = IGroupable.DEFAULT_JSON_GROUP_AS_BEHAVIOR;
                }
            }
        }
        return retval;
    }

    @NonNull
    public static XmlGroupAsBehavior groupAsXmlBehavior(@Nullable String inXml) {
        XmlGroupAsBehavior retval = IGroupable.DEFAULT_XML_GROUP_AS_BEHAVIOR;
        if (inXml != null) {
            switch (inXml) {
                case "GROUPED": {
                    retval = XmlGroupAsBehavior.GROUPED;
                    break;
                }
                case "UNGROUPED": {
                    retval = XmlGroupAsBehavior.UNGROUPED;
                    break;
                }
                default: {
                    retval = IGroupable.DEFAULT_XML_GROUP_AS_BEHAVIOR;
                }
            }
        }
        return retval;
    }

    @Nullable
    public static <NODE extends IAssemblyNodeItem> NODE toNodeItem(@NonNull IBindingMetaschemaModule module, @NonNull QName definitionQName, int position) {
        IDocumentNodeItem moduleNodeItem = module.getSourceNodeItem();
        return (NODE)((IAssemblyNodeItem)moduleNodeItem.getModelItemsByName(definitionQName).get(position));
    }
}

