/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.maven.plugin;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import gov.nist.secauto.metaschema.core.metapath.MetapathException;
import gov.nist.secauto.metaschema.core.model.IConstraintLoader;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.IModuleLoader;
import gov.nist.secauto.metaschema.core.model.IResourceLocation;
import gov.nist.secauto.metaschema.core.model.MetaschemaException;
import gov.nist.secauto.metaschema.core.model.constraint.ConstraintValidationFinding;
import gov.nist.secauto.metaschema.core.model.constraint.ExternalConstraintsModulePostProcessor;
import gov.nist.secauto.metaschema.core.model.constraint.IConstraintSet;
import gov.nist.secauto.metaschema.core.model.validation.AbstractValidationResultProcessor;
import gov.nist.secauto.metaschema.core.model.validation.IValidationFinding;
import gov.nist.secauto.metaschema.core.model.validation.IValidationResult;
import gov.nist.secauto.metaschema.core.model.validation.JsonSchemaContentValidator;
import gov.nist.secauto.metaschema.core.model.validation.XmlSchemaContentValidator;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.DefaultBindingContext;
import gov.nist.secauto.metaschema.databind.IBindingContext;
import gov.nist.secauto.metaschema.databind.PostProcessingModuleLoaderStrategy;
import gov.nist.secauto.metaschema.databind.SimpleModuleLoaderStrategy;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedClass;
import gov.nist.secauto.metaschema.databind.codegen.IGeneratedModuleClass;
import gov.nist.secauto.metaschema.databind.codegen.IModuleBindingGenerator;
import gov.nist.secauto.metaschema.databind.codegen.IProduction;
import gov.nist.secauto.metaschema.databind.codegen.JavaCompilerSupport;
import gov.nist.secauto.metaschema.databind.codegen.JavaGenerator;
import gov.nist.secauto.metaschema.databind.codegen.ModuleCompilerHelper;
import gov.nist.secauto.metaschema.databind.codegen.config.DefaultBindingConfiguration;
import gov.nist.secauto.metaschema.databind.codegen.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.databind.model.IBoundModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.BindingModuleLoader;
import gov.nist.secauto.metaschema.databind.model.metaschema.IBindingMetaschemaModule;
import gov.nist.secauto.metaschema.databind.model.metaschema.binding.MetaschemaModelModule;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.DiagnosticCollector;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.xml.sax.SAXParseException;

public abstract class AbstractMetaschemaMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.xml"};
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject mavenProject;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojoExecution;
    @Component
    private BuildContext buildContext;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true, required=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${project.build.directory}/metaschema", readonly=true, required=true)
    protected File staleFileDirectory;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/metaschema", required=true, property="outputDirectory")
    private File outputDirectory;
    @Parameter(defaultValue="${basedir}/src/main/metaschema")
    private File metaschemaDir;
    @Parameter(property="constraints")
    private File[] constraints;
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter(property="metaschema.skip", defaultValue="false")
    private boolean skip;

    protected final BuildContext getBuildContext() {
        return this.buildContext;
    }

    protected final MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected final List<Artifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="this is a data holder")
    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    protected void setOutputDirectory(File outputDirectory) {
        Objects.requireNonNull(outputDirectory, "outputDirectory");
        this.outputDirectory = outputDirectory;
    }

    protected final String getEncoding() {
        String encoding;
        if (this.encoding != null) {
            encoding = this.encoding;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Using configured encoding [%s].", encoding));
            }
        } else {
            encoding = Charset.defaultCharset().displayName();
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)String.format("Using system encoding [%s]. This build is platform dependent!", encoding));
            }
        }
        return encoding;
    }

    protected Stream<File> getModuleSources() {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.metaschemaDir);
        ds.setIncludes(this.includes != null && this.includes.length > 0 ? this.includes : DEFAULT_INCLUDES);
        ds.setExcludes(this.excludes != null && this.excludes.length > 0 ? this.excludes : null);
        ds.addDefaultExcludes();
        ds.setCaseSensitive(true);
        ds.setFollowSymlinks(false);
        ds.scan();
        return Stream.of(ds.getIncludedFiles()).map(filename -> new File(this.metaschemaDir, (String)filename)).distinct();
    }

    @NonNull
    protected IBindingContext newBindingContext(@NonNull IModuleLoader.IModulePostProcessor modulePostProcessor) throws IOException, MetaschemaException {
        return new DefaultBindingContext((IBindingContext.IModuleLoaderStrategy)new PostProcessingModuleLoaderStrategy(CollectionUtil.singletonList((Object)modulePostProcessor), (IBindingContext.IModuleLoaderStrategy)new SimpleModuleLoaderStrategy((IModuleBindingGenerator)new ModuleBindingGenerator((Path)ObjectUtils.notNull((Object)Files.createDirectories(Paths.get("target/metaschema-codegen-modules", new String[0]), new FileAttribute[0])), (IBindingConfiguration)new DefaultBindingConfiguration()))));
    }

    @NonNull
    protected List<IConstraintSet> getConstraints() throws MojoExecutionException {
        IConstraintLoader loader = IBindingContext.getConstraintLoader();
        ArrayList constraintSets = new ArrayList(this.constraints.length);
        for (File constraint : this.constraints) {
            try {
                constraintSets.addAll((Collection)loader.load((File)ObjectUtils.notNull((Object)constraint)));
            }
            catch (MetaschemaException | IOException ex) {
                throw new MojoExecutionException("Loading of external constraints failed", (Exception)ex);
            }
        }
        return CollectionUtil.unmodifiableList(constraintSets);
    }

    protected boolean shouldExecutionBeSkipped() {
        return this.skip;
    }

    protected abstract String getStaleFileName();

    protected final File getStaleFile() {
        StringBuilder builder = new StringBuilder();
        if (this.getMojoExecution() != null) {
            builder.append(this.getMojoExecution().getExecutionId()).append('-');
        }
        builder.append(this.getStaleFileName());
        return new File(this.staleFileDirectory, builder.toString());
    }

    protected boolean isGenerationRequired() {
        boolean generate;
        File staleFile = this.getStaleFile();
        boolean bl = generate = !staleFile.exists();
        if (generate) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("Stale file '%s' doesn't exist! Generating source files.", staleFile.getPath()));
            }
            generate = true;
        } else {
            generate = false;
            long staleLastModified = staleFile.lastModified();
            BuildContext buildContext = this.getBuildContext();
            URI metaschemaDirRelative = this.getMavenProject().getBasedir().toURI().relativize(this.metaschemaDir.toURI());
            if (buildContext.isIncremental() && buildContext.hasDelta(metaschemaDirRelative.toString())) {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("metaschemaDirRelative: " + metaschemaDirRelative.toString()));
                }
                generate = true;
            }
            if (!generate) {
                for (File sourceFile : this.getModuleSources().collect(Collectors.toList())) {
                    if (this.getLog().isInfoEnabled()) {
                        this.getLog().info((CharSequence)("Source file: " + sourceFile.getPath()));
                    }
                    if (sourceFile.lastModified() <= staleLastModified) continue;
                    generate = true;
                }
            }
        }
        return generate;
    }

    protected Set<String> getClassPath() throws DependencyResolutionRequiredException {
        LinkedHashSet<String> pathElements;
        try {
            pathElements = new LinkedHashSet<String>(this.getMavenProject().getCompileClasspathElements());
        }
        catch (DependencyResolutionRequiredException ex) {
            this.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)ex);
            throw ex;
        }
        if (this.pluginArtifacts != null) {
            for (Artifact a : this.getPluginArtifacts()) {
                if (a.getFile() == null) continue;
                pathElements.add(a.getFile().getAbsolutePath());
            }
        }
        return pathElements;
    }

    @NonNull
    protected Set<IModule> getModulesToGenerateFor(@NonNull IBindingContext bindingContext, @NonNull IModuleLoader.IModulePostProcessor modulePostProcessor) throws MetaschemaException, IOException {
        BindingModuleLoader loader = new BindingModuleLoader(bindingContext, (module, ctx) -> modulePostProcessor.processModule(module));
        loader.allowEntityResolution();
        LoggingValidationHandler validationHandler = new LoggingValidationHandler();
        HashSet<IModule> modules = new HashSet<IModule>();
        for (File source : this.getModuleSources().collect(Collectors.toList())) {
            assert (source != null);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Using metaschema source: " + source.getPath()));
            }
            IBindingMetaschemaModule module2 = (IBindingMetaschemaModule)loader.load(source);
            IValidationResult result = bindingContext.validate(module2.getSourceNodeItem(), loader.getBindingContext().newBoundLoader(), null);
            validationHandler.handleResults(result);
            modules.add((IModule)module2);
        }
        return modules;
    }

    protected void createStaleFile(@NonNull File staleFile) throws MojoExecutionException {
        if (!this.staleFileDirectory.exists() && !this.staleFileDirectory.mkdirs()) {
            throw new MojoExecutionException("Unable to create output directory: " + String.valueOf(this.staleFileDirectory));
        }
        try (OutputStream os = Files.newOutputStream(staleFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            os.close();
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Created stale file: " + String.valueOf(staleFile)));
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to write stale file: " + staleFile.getPath(), (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        boolean generate;
        File staleFile;
        block14: {
            staleFile = this.getStaleFile();
            try {
                staleFile = (File)ObjectUtils.notNull((Object)staleFile.getCanonicalFile());
            }
            catch (IOException ex) {
                if (!this.getLog().isWarnEnabled()) break block14;
                this.getLog().warn((CharSequence)"Unable to resolve canonical path to stale file. Treating it as not existing.", (Throwable)ex);
            }
        }
        if (this.shouldExecutionBeSkipped()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Generation is configured to be skipped. Skipping.", new Object[0]));
            }
            generate = false;
        } else if (staleFile.exists()) {
            generate = this.isGenerationRequired();
        } else {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("Stale file '%s' doesn't exist! Generation is required.", staleFile.getPath()));
            }
            generate = true;
        }
        if (generate) {
            List<File> generatedFiles;
            List<IConstraintSet> constraints = this.getConstraints();
            LimitedExternalConstraintsModulePostProcessor modulePostProcessor = new LimitedExternalConstraintsModulePostProcessor(constraints);
            try {
                generatedFiles = this.performGeneration((IModuleLoader.IModulePostProcessor)modulePostProcessor);
            }
            finally {
                this.createStaleFile(staleFile);
            }
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("Generated %d files.", generatedFiles.size()));
            }
            for (File file : generatedFiles) {
                this.getBuildContext().refresh(file);
            }
        }
    }

    @NonNull
    private List<File> performGeneration(@NonNull IModuleLoader.IModulePostProcessor modulePostProcessor) throws MojoExecutionException {
        Set<IModule> modules;
        IBindingContext bindingContext;
        File outputDir = this.getOutputDirectory();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format("Using outputDirectory: %s", outputDir.getPath()));
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new MojoExecutionException("Unable to create output directory: " + String.valueOf(outputDir));
        }
        try {
            bindingContext = this.newBindingContext(modulePostProcessor);
        }
        catch (MetaschemaException | IOException ex) {
            throw new MojoExecutionException("Failed to create the binding context", (Exception)ex);
        }
        try {
            modules = this.getModulesToGenerateFor(bindingContext, modulePostProcessor);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Loading of metaschema modules failed", ex);
        }
        return this.generate(modules);
    }

    @NonNull
    protected abstract List<File> generate(@NonNull Set<IModule> var1) throws MojoExecutionException;

    public class ModuleBindingGenerator
    implements IModuleBindingGenerator {
        @NonNull
        private final Path compilePath;
        @NonNull
        private final ClassLoader classLoader;
        @NonNull
        private final IBindingConfiguration bindingConfiguration;

        public ModuleBindingGenerator(@NonNull Path compilePath, IBindingConfiguration bindingConfiguration) {
            this.compilePath = compilePath;
            this.classLoader = ModuleCompilerHelper.newClassLoader((Path)compilePath, (ClassLoader)((ClassLoader)ObjectUtils.notNull((Object)Thread.currentThread().getContextClassLoader())));
            this.bindingConfiguration = bindingConfiguration;
        }

        @NonNull
        public IProduction generateClasses(@NonNull IModule module) {
            IProduction production;
            try {
                production = JavaGenerator.generate((IModule)module, (Path)this.compilePath, (IBindingConfiguration)this.bindingConfiguration);
            }
            catch (IOException ex) {
                throw new MetapathException(String.format("Unable to generate and compile classes for module '%s'.", module.getLocation()), (Throwable)ex);
            }
            return production;
        }

        private void compileClasses(@NonNull IProduction production, @NonNull Path classDir) throws IOException, DependencyResolutionRequiredException {
            List classesToCompile = production.getGeneratedClasses().collect(Collectors.toList());
            List classes = (List)ObjectUtils.notNull(classesToCompile.stream().map(IGeneratedClass::getClassFile).collect(Collectors.toUnmodifiableList()));
            JavaCompilerSupport compiler = new JavaCompilerSupport(classDir);
            compiler.setLogger(new JavaCompilerSupport.Logger(){

                public boolean isDebugEnabled() {
                    return AbstractMetaschemaMojo.this.getLog().isDebugEnabled();
                }

                public boolean isInfoEnabled() {
                    return AbstractMetaschemaMojo.this.getLog().isInfoEnabled();
                }

                public void debug(String msg) {
                    AbstractMetaschemaMojo.this.getLog().debug((CharSequence)msg);
                }

                public void info(String msg) {
                    AbstractMetaschemaMojo.this.getLog().info((CharSequence)msg);
                }
            });
            AbstractMetaschemaMojo.this.getClassPath().forEach(arg_0 -> ((JavaCompilerSupport)compiler).addToClassPath(arg_0));
            JavaCompilerSupport.CompilationResult result = compiler.compile(classes);
            if (!result.isSuccessful()) {
                DiagnosticCollector diagnostics = new DiagnosticCollector();
                if (AbstractMetaschemaMojo.this.getLog().isErrorEnabled()) {
                    AbstractMetaschemaMojo.this.getLog().error((CharSequence)("diagnostics: " + diagnostics.getDiagnostics().toString()));
                }
                throw new IllegalStateException(String.format("failed to compile classes: %s", classesToCompile.stream().map(clazz -> clazz.getClassName().canonicalName()).collect(Collectors.joining(","))));
            }
        }

        public Class<? extends IBoundModule> generate(IModule module) {
            IProduction production = this.generateClasses(module);
            try {
                this.compileClasses(production, this.compilePath);
            }
            catch (IOException | DependencyResolutionRequiredException ex) {
                throw new IllegalStateException("failed to compile classes", ex);
            }
            IGeneratedModuleClass moduleClass = (IGeneratedModuleClass)ObjectUtils.requireNonNull((Object)production.getModuleProduction(module));
            try {
                return moduleClass.load(this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    protected final class LoggingValidationHandler
    extends AbstractValidationResultProcessor {
        protected LoggingValidationHandler() {
        }

        private <T extends IValidationFinding> void handleFinding(@NonNull T finding, @NonNull Function<T, CharSequence> formatter) {
            Log log = AbstractMetaschemaMojo.this.getLog();
            switch (finding.getSeverity()) {
                case CRITICAL: 
                case ERROR: {
                    if (!log.isErrorEnabled()) break;
                    log.error(formatter.apply(finding), finding.getCause());
                    break;
                }
                case WARNING: {
                    if (!log.isWarnEnabled()) break;
                    AbstractMetaschemaMojo.this.getLog().warn(formatter.apply(finding), finding.getCause());
                    break;
                }
                case INFORMATIONAL: {
                    if (!log.isInfoEnabled()) break;
                    AbstractMetaschemaMojo.this.getLog().info(formatter.apply(finding), finding.getCause());
                    break;
                }
                default: {
                    if (!log.isDebugEnabled()) break;
                    AbstractMetaschemaMojo.this.getLog().debug(formatter.apply(finding), finding.getCause());
                }
            }
        }

        protected void handleJsonValidationFinding(JsonSchemaContentValidator.JsonValidationFinding finding) {
            this.handleFinding(finding, this::getMessage);
        }

        protected void handleXmlValidationFinding(XmlSchemaContentValidator.XmlValidationFinding finding) {
            this.handleFinding(finding, this::getMessage);
        }

        protected void handleConstraintValidationFinding(ConstraintValidationFinding finding) {
            this.handleFinding(finding, this::getMessage);
        }

        @NonNull
        private CharSequence getMessage(JsonSchemaContentValidator.JsonValidationFinding finding) {
            StringBuilder builder = new StringBuilder();
            builder.append('[').append(finding.getCause().getPointerToViolation()).append("] ").append(finding.getMessage());
            URI documentUri = finding.getDocumentUri();
            if (documentUri != null) {
                builder.append(" [").append(documentUri.toString()).append(']');
            }
            return builder;
        }

        @NonNull
        private CharSequence getMessage(XmlSchemaContentValidator.XmlValidationFinding finding) {
            StringBuilder builder = new StringBuilder();
            builder.append(finding.getMessage()).append(" [");
            URI documentUri = finding.getDocumentUri();
            if (documentUri != null) {
                builder.append(documentUri.toString());
            }
            SAXParseException ex = finding.getCause();
            builder.append(finding.getMessage()).append('{').append(ex.getLineNumber()).append(',').append(ex.getColumnNumber()).append("}]");
            return builder;
        }

        @NonNull
        private CharSequence getMessage(@NonNull ConstraintValidationFinding finding) {
            StringBuilder builder = new StringBuilder();
            builder.append('[').append(finding.getTarget().getMetapath()).append(']');
            String id = finding.getIdentifier();
            if (id != null) {
                builder.append(' ').append(id);
            }
            builder.append(' ').append(finding.getMessage());
            URI documentUri = finding.getTarget().getBaseUri();
            IResourceLocation location = finding.getLocation();
            if (documentUri != null || location != null) {
                builder.append(" [");
            }
            if (documentUri != null) {
                builder.append(documentUri.toString());
            }
            if (location != null) {
                builder.append('{').append(location.getLine()).append(',').append(location.getColumn()).append('}');
            }
            if (documentUri != null || location != null) {
                builder.append(']');
            }
            return builder;
        }
    }

    private static class LimitedExternalConstraintsModulePostProcessor
    extends ExternalConstraintsModulePostProcessor {
        public LimitedExternalConstraintsModulePostProcessor(@NonNull Collection<IConstraintSet> additionalConstraintSets) {
            super(additionalConstraintSets);
        }

        public void processModule(IModule module) {
            if (!(module instanceof MetaschemaModelModule)) {
                super.processModule(module);
            }
        }
    }
}

