/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.maven.plugin;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.DefaultConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.configuration.IConfigurationFeature;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.maven.plugin.AbstractMetaschemaMojo;
import gov.nist.secauto.metaschema.schemagen.ISchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.JsonSchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.xml.XmlSchemaGenerator;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-schemas", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class GenerateSchemaMojo
extends AbstractMetaschemaMojo {
    @NonNull
    private static final String STALE_FILE_NAME = "generateSschemaStaleFile";
    @NonNull
    private static final XmlSchemaGenerator XML_SCHEMA_GENERATOR = new XmlSchemaGenerator();
    @NonNull
    private static final JsonSchemaGenerator JSON_SCHEMA_GENERATOR = new JsonSchemaGenerator();
    @Parameter
    private List<String> formats;
    @Parameter(defaultValue="true")
    private boolean inlineDefinitions = true;
    @Parameter(defaultValue="false")
    private boolean inlineChoiceDefinitions;

    protected boolean isInlineDefinitions() {
        return this.inlineDefinitions;
    }

    protected boolean isInlineChoiceDefinitions() {
        return this.inlineChoiceDefinitions;
    }

    @Override
    protected String getStaleFileName() {
        return STALE_FILE_NAME;
    }

    @Override
    @NonNull
    protected List<File> generate(@NonNull Set<IModule> modules) throws MojoExecutionException {
        Set schemaFormats;
        DefaultConfiguration schemaGenerationConfig = new DefaultConfiguration();
        if (this.isInlineDefinitions()) {
            schemaGenerationConfig.enableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_DEFINITIONS);
        } else {
            schemaGenerationConfig.disableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_DEFINITIONS);
        }
        if (this.isInlineChoiceDefinitions()) {
            schemaGenerationConfig.enableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS);
        } else {
            schemaGenerationConfig.disableFeature((IConfigurationFeature)SchemaGenerationFeature.INLINE_CHOICE_DEFINITIONS);
        }
        if (this.formats != null) {
            schemaFormats = (Set)ObjectUtils.notNull(EnumSet.noneOf(SchemaFormat.class));
            block8: for (String format : this.formats) {
                switch (format.toLowerCase(Locale.ROOT)) {
                    case "xsd": {
                        schemaFormats.add(SchemaFormat.XSD);
                        continue block8;
                    }
                    case "json": {
                        schemaFormats.add(SchemaFormat.JSON_SCHEMA);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Unsupported schema format: " + format);
            }
        } else {
            schemaFormats = (Set)ObjectUtils.notNull(EnumSet.allOf(SchemaFormat.class));
        }
        Path outputDirectory = (Path)ObjectUtils.notNull((Object)this.getOutputDirectory().toPath());
        LinkedList<File> generatedSchemas = new LinkedList<File>();
        for (IModule module : modules) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)String.format("Processing metaschema: %s", module.getLocation()));
            }
            if (module.getExportedRootAssemblyDefinitions().isEmpty()) continue;
            generatedSchemas.addAll(this.generateSchemas(module, (IConfiguration<SchemaGenerationFeature<?>>)schemaGenerationConfig, outputDirectory, schemaFormats));
        }
        return CollectionUtil.unmodifiableList(generatedSchemas);
    }

    @NonNull
    private List<File> generateSchemas(@NonNull IModule module, @NonNull IConfiguration<SchemaGenerationFeature<?>> schemaGenerationConfig, @NonNull Path outputDirectory, @NonNull Set<SchemaFormat> schemaFormats) throws MojoExecutionException {
        String filename;
        String shortName = module.getShortName();
        LinkedList<File> generatedSchemas = new LinkedList<File>();
        if (schemaFormats.contains((Object)SchemaFormat.XSD)) {
            try {
                filename = String.format("%s_schema.xsd", shortName);
                Path xmlSchema = (Path)ObjectUtils.notNull((Object)outputDirectory.resolve(filename));
                GenerateSchemaMojo.generateSchema(module, schemaGenerationConfig, xmlSchema, (ISchemaGenerator)XML_SCHEMA_GENERATOR);
                generatedSchemas.add(xmlSchema.toFile());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Unable to generate XML schema.", ex);
            }
        }
        if (schemaFormats.contains((Object)SchemaFormat.JSON_SCHEMA)) {
            try {
                filename = String.format("%s_schema.json", shortName);
                Path jsonSchema = (Path)ObjectUtils.notNull((Object)outputDirectory.resolve(filename));
                GenerateSchemaMojo.generateSchema(module, schemaGenerationConfig, jsonSchema, (ISchemaGenerator)JSON_SCHEMA_GENERATOR);
                generatedSchemas.add(jsonSchema.toFile());
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Unable to generate JSON schema.", ex);
            }
        }
        return CollectionUtil.unmodifiableList(generatedSchemas);
    }

    private static void generateSchema(@NonNull IModule module, @NonNull IConfiguration<SchemaGenerationFeature<?>> schemaGenerationConfig, @NonNull Path schemaPath, @NonNull ISchemaGenerator generator) throws IOException {
        try (Writer writer = (Writer)ObjectUtils.notNull((Object)Files.newBufferedWriter(schemaPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING));){
            generator.generateFromModule(module, writer, schemaGenerationConfig);
        }
    }

    public static enum SchemaFormat {
        XSD,
        JSON_SCHEMA;

    }
}

