/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.maven.plugin;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.databind.codegen.IProduction;
import gov.nist.secauto.metaschema.databind.codegen.JavaGenerator;
import gov.nist.secauto.metaschema.databind.codegen.config.DefaultBindingConfiguration;
import gov.nist.secauto.metaschema.databind.codegen.config.IBindingConfiguration;
import gov.nist.secauto.metaschema.maven.plugin.AbstractMetaschemaMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate-sources", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateSourcesMojo
extends AbstractMetaschemaMojo {
    private static final String STALE_FILE_NAME = "generateSourcesStaleFile";
    @Parameter
    protected File[] configs;

    @Override
    protected String getStaleFileName() {
        return STALE_FILE_NAME;
    }

    protected List<File> getConfigs() {
        List<File> retval = this.configs == null ? Collections.emptyList() : Arrays.asList(this.configs);
        return retval;
    }

    @Override
    @NonNull
    protected List<File> generate(@NonNull Set<IModule> modules) throws MojoExecutionException {
        IProduction production;
        DefaultBindingConfiguration bindingConfiguration = new DefaultBindingConfiguration();
        for (File config : this.getConfigs()) {
            try {
                if (this.getLog().isInfoEnabled()) {
                    this.getLog().info((CharSequence)("Loading binding configuration: " + config.getPath()));
                }
                bindingConfiguration.load(config);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(String.format("Unable to load binding configuration from '%s'.", config.getPath()), (Exception)ex);
            }
        }
        try {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Generating Java classes in: " + this.getOutputDirectory().getPath()));
            }
            production = JavaGenerator.generate(modules, (Path)((Path)ObjectUtils.notNull((Object)this.getOutputDirectory().toPath())), (IBindingConfiguration)bindingConfiguration);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Creation of Java classes failed.", (Exception)ex);
        }
        try {
            this.getMavenProject().addCompileSourceRoot(this.getOutputDirectory().getCanonicalFile().getPath());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to add output directory to maven sources.", (Exception)ex);
        }
        return (List)ObjectUtils.notNull(production.getGeneratedClasses().map(gen -> gen.getClassFile().toFile()).collect(Collectors.toUnmodifiableList()));
    }
}

