/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.metapath.MetapathExpression;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.model.IModelDefinition;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.core.model.INamedInstance;
import gov.nist.secauto.metaschema.core.model.IValuedDefinition;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValue;
import gov.nist.secauto.metaschema.core.model.constraint.IAllowedValuesConstraint;
import gov.nist.secauto.metaschema.core.util.CollectionUtil;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.IGenerationState;
import gov.nist.secauto.metaschema.schemagen.IInlineStrategy;
import gov.nist.secauto.metaschema.schemagen.ModuleIndex;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractGenerationState<WRITER, DATATYPE_MANAGER extends IDatatypeManager>
implements IGenerationState<WRITER> {
    @NonNull
    private final IModule module;
    @NonNull
    private final WRITER writer;
    @NonNull
    private final DATATYPE_MANAGER datatypeManager;
    @NonNull
    private final IInlineStrategy inlineStrategy;
    @NonNull
    private final ModuleIndex moduleIndex;

    public AbstractGenerationState(@NonNull IModule module, @NonNull WRITER writer, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration, @NonNull DATATYPE_MANAGER datatypeManager) {
        this.module = module;
        this.writer = writer;
        this.datatypeManager = datatypeManager;
        this.inlineStrategy = IInlineStrategy.newInlineStrategy(configuration);
        this.moduleIndex = ModuleIndex.indexDefinitions(module, this.inlineStrategy);
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public WRITER getWriter() {
        return this.writer;
    }

    @NonNull
    protected DATATYPE_MANAGER getDatatypeManager() {
        return this.datatypeManager;
    }

    @NonNull
    public ModuleIndex getMetaschemaIndex() {
        return this.moduleIndex;
    }

    @Override
    public boolean isInline(@NonNull IDefinition definition) {
        return this.inlineStrategy.isInline(definition, this.getMetaschemaIndex());
    }

    @NonNull
    protected static AllowedValueCollection getContextIndependentEnumeratedValues(@NonNull IValuedDefinition definition) {
        List<Object> values = new LinkedList<IAllowedValue>();
        boolean closed = false;
        for (IAllowedValuesConstraint constraint : definition.getAllowedValuesConstraints()) {
            if (!constraint.isAllowedOther()) {
                closed = true;
            }
            if (!MetapathExpression.CONTEXT_NODE.getPath().equals(constraint.getTarget())) {
                values = CollectionUtil.emptyList();
                break;
            }
            values.addAll(constraint.getAllowedValues().values());
        }
        return new AllowedValueCollection(closed, values);
    }

    private CharSequence getTypeContext(@NonNull IDefinition definition, @NonNull IModule childModule) {
        StringBuilder builder = new StringBuilder();
        if (definition.isInline()) {
            INamedInstance inlineInstance = definition.getInlineInstance();
            IModelDefinition parentDefinition = inlineInstance.getContainingDefinition();
            builder.append(this.getTypeContext((IDefinition)parentDefinition, childModule)).append(IGenerationState.toCamelCase(inlineInstance.getEffectiveName()));
        } else {
            builder.append(IGenerationState.toCamelCase(definition.getName()));
        }
        return builder;
    }

    @Override
    @NonNull
    public String getTypeNameForDefinition(@NonNull IDefinition definition, @Nullable String suffix) {
        StringBuilder builder = new StringBuilder().append(IGenerationState.toCamelCase(definition.getModelType().name())).append(IGenerationState.toCamelCase(definition.getContainingModule().getShortName()));
        if (this.isInline(definition)) {
            builder.append(IGenerationState.toCamelCase(definition.getEffectiveName()));
        } else {
            builder.append(this.getTypeContext(definition, definition.getContainingModule()));
        }
        if (suffix != null && !suffix.isBlank()) {
            builder.append(suffix);
        }
        builder.append("Type");
        return (String)ObjectUtils.notNull((Object)builder.toString());
    }

    public static class AllowedValueCollection {
        private final boolean closed;
        @NonNull
        private final List<IAllowedValue> values;

        public AllowedValueCollection(boolean closed, @NonNull List<IAllowedValue> values) {
            this.closed = closed;
            this.values = CollectionUtil.unmodifiableList(new ArrayList<IAllowedValue>(values));
        }

        public boolean isClosed() {
            return this.closed;
        }

        @NonNull
        public List<IAllowedValue> getValues() {
            return this.values;
        }
    }
}

