/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.configuration.IConfiguration;
import gov.nist.secauto.metaschema.core.model.IModule;
import gov.nist.secauto.metaschema.schemagen.SchemaGenerationFeature;
import gov.nist.secauto.metaschema.schemagen.json.JsonSchemaGenerator;
import gov.nist.secauto.metaschema.schemagen.xml.XmlSchemaGenerator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public interface ISchemaGenerator {
    public void generateFromModule(@NonNull IModule var1, @NonNull Writer var2, @NonNull IConfiguration<SchemaGenerationFeature<?>> var3);

    public static void generateSchema(@NonNull IModule module, @NonNull Path destination, @NonNull SchemaFormat asFormat, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) throws IOException {
        ISchemaGenerator schemaGenerator = asFormat.getSchemaGenerator();
        try (BufferedWriter writer = Files.newBufferedWriter(destination, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            if (!1.$assertionsDisabled && writer == null) {
                throw new AssertionError();
            }
            schemaGenerator.generateFromModule(module, writer, configuration);
            ((Writer)writer).flush();
        }
    }

    public static void generateSchema(@NonNull IModule module, @NonNull OutputStream os, @NonNull SchemaFormat asFormat, @NonNull IConfiguration<SchemaGenerationFeature<?>> configuration) throws IOException {
        ISchemaGenerator schemaGenerator = asFormat.getSchemaGenerator();
        OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        schemaGenerator.generateFromModule(module, writer, configuration);
        ((Writer)writer).flush();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum SchemaFormat {
        JSON(new JsonSchemaGenerator()),
        XML(new XmlSchemaGenerator());

        @NonNull
        private final ISchemaGenerator schemaGenerator;

        private SchemaFormat(ISchemaGenerator schemaGenerator) {
            this.schemaGenerator = schemaGenerator;
        }

        @NonNull
        public ISchemaGenerator getSchemaGenerator() {
            return this.schemaGenerator;
        }
    }
}

