/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.datatype;

import edu.umd.cs.findbugs.annotations.NonNull;
import gov.nist.secauto.metaschema.core.datatype.IDataTypeAdapter;
import gov.nist.secauto.metaschema.schemagen.datatype.IDatatypeManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractDatatypeManager
implements IDatatypeManager {
    @NonNull
    private static final Map<String, String> DATATYPE_TRANSLATION_MAP = new LinkedHashMap<String, String>();
    @NonNull
    private final Map<IDataTypeAdapter<?>, String> datatypeToTypeMap = new HashMap();

    @NonNull
    protected static Map<String, String> getDatatypeTranslationMap() {
        return Collections.unmodifiableMap(DATATYPE_TRANSLATION_MAP);
    }

    @Override
    public Set<String> getUsedTypes() {
        return new HashSet<String>(this.datatypeToTypeMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public String getTypeNameForDatatype(@NonNull IDataTypeAdapter<?> datatype) {
        AbstractDatatypeManager abstractDatatypeManager = this;
        synchronized (abstractDatatypeManager) {
            String name = this.datatypeToTypeMap.get(datatype);
            if (name == null) {
                name = AbstractDatatypeManager.getDatatypeTranslationMap().get(datatype.getPreferredName().getLocalPart());
                this.datatypeToTypeMap.put(datatype, name);
            }
            return name;
        }
    }

    static {
        DATATYPE_TRANSLATION_MAP.put("base64", "Base64Datatype");
        DATATYPE_TRANSLATION_MAP.put("boolean", "BooleanDatatype");
        DATATYPE_TRANSLATION_MAP.put("date", "DateDatatype");
        DATATYPE_TRANSLATION_MAP.put("date-with-timezone", "DateWithTimezoneDatatype");
        DATATYPE_TRANSLATION_MAP.put("date-time", "DateTimeDatatype");
        DATATYPE_TRANSLATION_MAP.put("date-time-with-timezone", "DateTimeWithTimezoneDatatype");
        DATATYPE_TRANSLATION_MAP.put("day-time-duration", "DayTimeDurationDatatype");
        DATATYPE_TRANSLATION_MAP.put("decimal", "DecimalDatatype");
        DATATYPE_TRANSLATION_MAP.put("email-address", "EmailAddressDatatype");
        DATATYPE_TRANSLATION_MAP.put("hostname", "HostnameDatatype");
        DATATYPE_TRANSLATION_MAP.put("integer", "IntegerDatatype");
        DATATYPE_TRANSLATION_MAP.put("ip-v4-address", "IPV4AddressDatatype");
        DATATYPE_TRANSLATION_MAP.put("ip-v6-address", "IPV6AddressDatatype");
        DATATYPE_TRANSLATION_MAP.put("markup-line", "MarkupLineDatatype");
        DATATYPE_TRANSLATION_MAP.put("markup-multiline", "MarkupMultilineDatatype");
        DATATYPE_TRANSLATION_MAP.put("non-negative-integer", "NonNegativeIntegerDatatype");
        DATATYPE_TRANSLATION_MAP.put("positive-integer", "PositiveIntegerDatatype");
        DATATYPE_TRANSLATION_MAP.put("string", "StringDatatype");
        DATATYPE_TRANSLATION_MAP.put("token", "TokenDatatype");
        DATATYPE_TRANSLATION_MAP.put("uri", "URIDatatype");
        DATATYPE_TRANSLATION_MAP.put("uri-reference", "URIReferenceDatatype");
        DATATYPE_TRANSLATION_MAP.put("uuid", "UUIDDatatype");
        DATATYPE_TRANSLATION_MAP.put("year-month-duration", "YearMonthDurationDatatype");
    }
}

