/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.secauto.metaschema.schemagen.json;

import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import gov.nist.secauto.metaschema.core.model.IDefinition;
import gov.nist.secauto.metaschema.core.util.ObjectUtils;
import gov.nist.secauto.metaschema.schemagen.json.IJsonGenerationState;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractDefinitionJsonSchema;
import gov.nist.secauto.metaschema.schemagen.json.impl.AbstractModelDefinitionJsonSchema;
import java.util.Comparator;

public interface IDefineableJsonSchema {
    public boolean isInline(@NonNull IJsonGenerationState var1);

    default public void generateSchemaOrRef(@NonNull ObjectNode obj, @NonNull IJsonGenerationState state) {
        if (this.isInline(state)) {
            this.generateInlineSchema(obj, state);
        } else {
            this.generateRef(obj, state);
        }
    }

    public void generateInlineSchema(@NonNull ObjectNode var1, @NonNull IJsonGenerationState var2);

    @NonNull
    public String getDefinitionName(@NonNull IJsonGenerationState var1);

    default public String getDefinitionRef(@NonNull IJsonGenerationState state) {
        return (String)ObjectUtils.notNull((Object)("#/definitions/" + this.getDefinitionName(state)));
    }

    default public void generateRef(@NonNull ObjectNode obj, @NonNull IJsonGenerationState state) {
        obj.put("$ref", this.getDefinitionRef(state));
    }

    default public void generateDefinition(@NonNull IJsonGenerationState state, @NonNull ObjectNode definitionsObject) {
        ObjectNode definitionObj = (ObjectNode)ObjectUtils.notNull((Object)definitionsObject.putObject(this.getDefinitionName(state)));
        definitionObj.put("$id", this.getDefinitionRef(state));
        this.generateInlineSchema(definitionObj, state);
    }

    public static interface IKey
    extends Comparable<IKey> {
        public static final Comparator<IKey> KEY_COMPARATOR = Comparator.comparing(key -> key.getDefinition().getContainingModule().getShortName()).thenComparing(key -> key.getDefinition().getEffectiveName()).thenComparing(IKey::getJsonKeyFlagName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(IKey::getDiscriminatorProperty, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(IKey::getDiscriminatorValue, Comparator.nullsFirst(Comparator.naturalOrder()));

        @NonNull
        public static IKey of(@NonNull IDefinition definition) {
            return new AbstractDefinitionJsonSchema.SimpleKey(definition);
        }

        @NonNull
        public static IKey of(@NonNull IDefinition definition, @Nullable String jsonKeyFlagName, @Nullable String discriminatorProperty, @Nullable String discriminatorValue) {
            IKey retval = jsonKeyFlagName != null || discriminatorProperty != null || discriminatorValue != null ? new AbstractModelDefinitionJsonSchema.ComplexKey(definition, jsonKeyFlagName, discriminatorProperty, discriminatorValue) : IKey.of(definition);
            return retval;
        }

        @NonNull
        public IDefinition getDefinition();

        @Nullable
        public String getJsonKeyFlagName();

        @Nullable
        public String getDiscriminatorProperty();

        @Nullable
        public String getDiscriminatorValue();

        @Override
        default public int compareTo(IKey other) {
            return KEY_COMPARATOR.compare(this, other);
        }
    }
}

